package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Fri May 22 13:25:34 UTC 2015")
public abstract class PersonDAOAbstract<E extends Person> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Person.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Person;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Pet> list = getContext()
                                                    .getDAO(Pet.class)
                                                    .findAllByProperties(Pet.PROPERTY_PERSON, entity);
                                            for (Pet item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPerson())) {
                                                    item.setPerson(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Person.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.PROPERTY_NAME, v);
        return result;
    }

    public E findByFirstname(String v) throws TopiaException {
        E result = findByProperty(Person.PROPERTY_FIRSTNAME, v);
        return result;
    }

    public List<E> findAllByFirstname(String v) throws TopiaException {
        List<E> result = findAllByProperty(Person.PROPERTY_FIRSTNAME, v);
        return result;
    }

    public E findContainsPet(Pet v) throws TopiaException {
        E result = findContains(Person.PROPERTY_PET, v);
        return result;
    }

    public List<E> findAllContainsPet(Pet v) throws TopiaException {
        List<E> result = findAllContains(Person.PROPERTY_PET, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Pet.class) {
            PetDAO dao = (PetDAO)
                getContext().getDAO(Pet.class);
            tmp = dao.findAllByPerson(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Pet.class, entity);
        if (!list.isEmpty()) {
            result.put(Pet.class, list);
        }

        return result;
    }

} //PersonDAOAbstract<E extends Person>
