package org.nuiton.topia.test.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Fri May 22 13:25:34 UTC 2015")
public abstract class PersonAbstract extends TopiaEntityAbstract implements Person {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : firstname
     */
    protected String firstname;

    /**
     * Nom de l'attribut en BD : pet
     */
    protected Collection<Pet> pet;

    private static final long serialVersionUID = 3979040660960470069L;

    static {
    
        I18n.n("topia.test.common.person");
        I18n.n("topia.test.common.name");
        I18n.n("topia.test.common.firstname");
        I18n.n("topia.test.common.pet");
    }

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_FIRSTNAME, String.class, firstname);
        visitor.visit(this, PROPERTY_PET, Collection.class, Pet.class, pet);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);

        String result = this.name;

        fireOnPostRead(PROPERTY_NAME, name);

        return result;
    }

    @Override
    public void setFirstname(String firstname) {
        String oldValue = this.firstname;
        fireOnPreWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
        this.firstname = firstname;
        fireOnPostWrite(PROPERTY_FIRSTNAME, oldValue, firstname);
    }

    @Override
    public String getFirstname() {
        fireOnPreRead(PROPERTY_FIRSTNAME, firstname);

        String result = this.firstname;

        fireOnPostRead(PROPERTY_FIRSTNAME, firstname);

        return result;
    }

    @Override
    public void addPet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, null, pet);
        if (this.pet == null) {
            this.pet = new ArrayList<Pet>();
        }

        pet.setPerson(this);

        this.pet.add(pet);
        fireOnPostWrite(PROPERTY_PET, this.pet.size(), null, pet);
    }

    @Override
    public void addAllPet(Collection<Pet> pet) {
        if (pet == null) {
            return;
        }
        for (Pet item : pet) {
            addPet(item);
        }
    }

    @Override
    public void setPet(Collection<Pet> pet) {
        // Copy elements to keep data for fire with new reference
        Collection<Pet> oldValue = this.pet != null ? new ArrayList<Pet>(this.pet) : null;
        fireOnPreWrite(PROPERTY_PET, oldValue, pet);
        this.pet = pet;
        fireOnPostWrite(PROPERTY_PET, oldValue, pet);
    }

    @Override
    public void removePet(Pet pet) {
        fireOnPreWrite(PROPERTY_PET, pet, null);
        if (this.pet == null || !this.pet.remove(pet)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        pet.setPerson(null);

        fireOnPostWrite(PROPERTY_PET, this.pet.size() + 1, pet, null);
    }

    @Override
    public void clearPet() {
        if (this.pet == null) {
            return;
        }
        for (Pet item : this.pet) {
            item.setPerson(null);
        }
        Collection<Pet> oldValue = new ArrayList<Pet>(this.pet);
        fireOnPreWrite(PROPERTY_PET, oldValue, this.pet);
        this.pet.clear();
        fireOnPostWrite(PROPERTY_PET, oldValue, this.pet);
    }

    @Override
    public Collection<Pet> getPet() {
        return pet;
    }

    @Override
    public Pet getPetByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pet, topiaId);
    }

    @Override
    public int sizePet() {
        if (pet == null) {
            return 0;
        }
        return pet.size();
    }

    @Override
    public boolean isPetEmpty() {
        int size = sizePet();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_NAME, this.name).
            append(PROPERTY_FIRSTNAME, this.firstname).
         toString();
        return result;
    }

} //PersonAbstract
