/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SQLQuery;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.jdbc.Work;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class DBMapping {
    protected static final Log log = LogFactory.getLog(DBMapping.class);
    protected static final String CLASS_PATTERN = "(.+)\\.class\\.tagvalue\\.dbName";
    protected static final String DBNAME_ATTRIBUTE_PATTERN = "(.+).attribute.(\\w+)\\.tagvalue\\.dbName";
    protected static final String SEQUENCE_ATTRIBUTE_PATTERN = "(.+).attribute.(\\w+)\\.tagvalue\\.sequence";
    protected static final String CREATE_SEQUENCE_FORMAT = "create sequence %1$s%2$s_%3$s_sequence start (select max(%3$s) from %1$s%2$s);";
    protected static final String UPDATE_SEQUENCE_FORMAT = "alter sequence %1$s%2$s_%3$s_sequence restart with (select max(%3$s) from %1$s%2$s);";
    protected static final String CURRENT_VALUE_SEQUENCE_FORMAT = "select %1$s%2$s_%3$s_sequence.currval";
    protected static final String NEXT_VALUE_SEQUENCE_FORMAT = "select %1$s%2$s_%3$s_sequence.nextval";
    protected static final String SCHEMA_FORMAT = "model.tagvalue.dbSchema";
    protected static final String DOT = ".";
    protected Map<String, String> mappingBeanToDb = new TreeMap<String, String>();
    protected Map<String, Class<? extends TopiaEntity>> sequences = new TreeMap<String, Class<? extends TopiaEntity>>();
    protected String schema;

    protected abstract Class<? extends TopiaEntity> getContractClass(Class<? extends TopiaEntity> var1) throws TopiaException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBMapping(String propertyFile, String path) throws IOException {
        InputStream stream;
        if (propertyFile == null) {
            propertyFile = path;
        }
        if ((stream = this.getClass().getResourceAsStream(propertyFile)) == null) {
            throw new IllegalStateException("no tagsvalues defined (did not find the resource : " + propertyFile + ")");
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            this.initMapping(props);
        }
        finally {
            props.clear();
            stream.close();
        }
    }

    public void init(TopiaContext ctxt, boolean doCreate, boolean doUpdate) throws TopiaException {
        TopiaContext newContext;
        if (this.sequences.isEmpty()) {
            return;
        }
        String firstSequenceKey = this.sequences.keySet().iterator().next();
        boolean exists = this.existSequence(firstSequenceKey, newContext = ctxt.beginTransaction());
        if (!exists) {
            if (!doCreate) {
                return;
            }
            this.createSequences(newContext);
        } else if (doUpdate) {
            this.updateSequences(newContext);
        }
        newContext.commitTransaction();
        newContext.closeContext();
    }

    public void createSequences(TopiaContext ctxt) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)"start create db sequences...");
        }
        for (String sequenceKey : this.sequences.keySet()) {
            this.createSequence(sequenceKey, ctxt, false);
        }
    }

    public void updateSequences(TopiaContext ctxt) throws TopiaException {
        if (log.isInfoEnabled()) {
            log.info((Object)"start update db sequences...");
        }
        for (String sequenceKey : this.sequences.keySet()) {
            this.updateSequence(sequenceKey, ctxt, false);
        }
    }

    public boolean existSequence(String sequenceKey, TopiaContext ctxt) throws TopiaException {
        return this.existSequence(sequenceKey, ctxt, true);
    }

    public void createSequence(String sequenceKey, TopiaContext ctxt) throws TopiaException {
        this.createSequence(sequenceKey, ctxt, true);
    }

    public void updateSequence(String sequenceKey, TopiaContext ctxt) throws TopiaException {
        this.updateSequence(sequenceKey, ctxt, true);
    }

    public BigInteger getCurrentValueFromSequence(String sequenceKey, TopiaContext ctxt) throws TopiaException {
        return this.getCurrentValueFromSequence(sequenceKey, ctxt, true);
    }

    public BigInteger getNextValueFromSequence(String sequenceKey, TopiaContext ctxt) throws TopiaException {
        return this.getNextValueFromSequence(sequenceKey, ctxt, true);
    }

    public boolean existSequence(Class<? extends TopiaEntity> entityClass, String propertyName, TopiaContext ctxt) throws TopiaException {
        String sequenceKey = this.checkSequence(entityClass, propertyName);
        return this.existSequence(sequenceKey, ctxt, false);
    }

    public void createSequence(Class<? extends TopiaEntity> entityClass, String propertyName, TopiaContext ctxt) throws TopiaException {
        String sequenceKey = this.checkSequence(entityClass, propertyName);
        this.createSequence(sequenceKey, ctxt, false);
    }

    public void updateSequence(Class<? extends TopiaEntity> entityClass, String propertyName, TopiaContext ctxt) throws TopiaException {
        String sequenceKey = this.checkSequence(entityClass, propertyName);
        this.updateSequence(sequenceKey, ctxt, false);
    }

    public BigInteger getCurrentValueFromSequence(Class<? extends TopiaEntity> entityClass, String propertyName, TopiaContext ctxt) throws TopiaException {
        String sequenceKey = this.checkSequence(entityClass, propertyName);
        return this.getCurrentValueFromSequence(sequenceKey, ctxt, false);
    }

    public BigInteger getNextValueFromSequence(Class<? extends TopiaEntity> entityClass, String propertyName, TopiaContext ctxt) throws TopiaException {
        String sequenceKey = this.checkSequence(entityClass, propertyName);
        return this.getNextValueFromSequence(sequenceKey, ctxt, false);
    }

    public Iterator<String> getSequenceKeysIterator() {
        return this.sequences.keySet().iterator();
    }

    public boolean existSequence(String sequenceKey, TopiaContext ctxt, boolean check) throws TopiaException {
        if (check) {
            this.checkSequence(sequenceKey);
        }
        try {
            this.getCurrentValueFromSequence(sequenceKey, ctxt, false);
        }
        catch (TopiaException e) {
            if (e.getCause() != null && e.getCause().getClass() == SQLGrammarException.class) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public void createSequence(String sequenceKey, TopiaContext ctxt, boolean check) throws TopiaException {
        if (check) {
            this.checkSequence(sequenceKey);
        }
        String sql = this.getSequenceSQL(CREATE_SEQUENCE_FORMAT, sequenceKey);
        this.doSQLWork(ctxt, sql);
        BigInteger currentValue = this.getNextValueFromSequence(sequenceKey, ctxt, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)(sequenceKey + " currentValue " + currentValue.intValue()));
        }
    }

    public void updateSequence(String sequenceKey, TopiaContext ctxt, boolean check) throws TopiaException {
        if (check) {
            this.checkSequence(sequenceKey);
        }
        String sql = this.getSequenceSQL(UPDATE_SEQUENCE_FORMAT, sequenceKey);
        this.doSQLWork(ctxt, sql);
        BigInteger currentValue = this.getNextValueFromSequence(sequenceKey, ctxt, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)(sequenceKey + " currentValue " + currentValue.intValue()));
        }
    }

    public BigInteger getCurrentValueFromSequence(String sequenceKey, TopiaContext ctxt, boolean check) throws TopiaException {
        if (check) {
            this.checkSequence(sequenceKey);
        }
        String sql = this.getSequenceSQL(CURRENT_VALUE_SEQUENCE_FORMAT, sequenceKey);
        TopiaContext newCtxt = ctxt.beginTransaction();
        BigInteger bigInteger = this.getBigInteger(newCtxt, sql, BigInteger.ZERO);
        newCtxt.closeContext();
        return bigInteger;
    }

    public BigInteger getNextValueFromSequence(String sequenceKey, TopiaContext ctxt, boolean check) throws TopiaException {
        if (check) {
            this.checkSequence(sequenceKey);
        }
        String sql = this.getSequenceSQL(NEXT_VALUE_SEQUENCE_FORMAT, sequenceKey);
        return this.getBigInteger(ctxt, sql, BigInteger.ZERO);
    }

    protected String getDBProperty(Class<? extends TopiaEntity> entityClass, String property) throws TopiaException {
        Class<? extends TopiaEntity> contractClass = this.getContractClass(entityClass);
        String key = contractClass.getName() + DOT + property;
        String colName = this.mappingBeanToDb.get(key);
        if (colName == null) {
            colName = property;
        }
        return colName;
    }

    protected String getDBTable(Class<? extends TopiaEntity> entityClass) throws TopiaException {
        Class<? extends TopiaEntity> contractClass = this.getContractClass(entityClass);
        String key = contractClass.getName();
        String colName = this.mappingBeanToDb.get(key);
        if (colName == null) {
            colName = contractClass.getSimpleName().toLowerCase();
        }
        return colName;
    }

    protected String getSequenceSQL(String pattern, Class<? extends TopiaEntity> entityClass, String propertyName) throws TopiaException {
        String dbTable = this.getDBTable(entityClass);
        String dbPropertyName = this.getDBProperty(entityClass, propertyName);
        String sql = String.format(pattern, this.schema, dbTable, dbPropertyName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("sql : " + sql));
        }
        return sql;
    }

    protected String getSequenceSQL(String pattern, String sequenceKey) throws TopiaException {
        Class<? extends TopiaEntity> entityClass = this.sequences.get(sequenceKey);
        String dbTable = this.getDBTable(entityClass);
        String propertyName = this.getSequencePropertyName(sequenceKey);
        String dbPropertyName = this.getDBProperty(entityClass, propertyName);
        String sql = String.format(pattern, this.schema, dbTable, dbPropertyName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("sql : " + sql));
        }
        return sql;
    }

    protected BigInteger getBigInteger(TopiaContext ctxt, String sql, BigInteger defaultSize) throws TopiaException {
        BigInteger size = defaultSize;
        if (ctxt != null) {
            try {
                SQLQuery query = ((TopiaContextImpl)ctxt).getHibernate().createSQLQuery(sql);
                size = (BigInteger)query.list().get(0);
            }
            catch (SQLGrammarException e) {
                throw new TopiaException(e);
            }
        }
        return size;
    }

    protected void doSQLWork(TopiaContext ctxt, final String sql) throws TopiaException {
        if (ctxt != null) {
            ((TopiaContextImpl)ctxt).getHibernate().doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sql);
                    }
                    Statement stmt = connection.createStatement();
                    stmt.execute(sql);
                }
            });
        }
    }

    protected String getSequencePropertyName(String sequenceKey) {
        int dotIndex = sequenceKey.lastIndexOf(DOT);
        return sequenceKey.substring(dotIndex + 1);
    }

    protected String checkSequence(Class<? extends TopiaEntity> entityClass, String propertyName) throws IllegalArgumentException, TopiaException {
        Class<? extends TopiaEntity> contractClass = this.getContractClass(entityClass);
        String sequenceKey = contractClass.getName() + DOT + propertyName;
        if (!this.sequences.containsKey(sequenceKey)) {
            throw new IllegalArgumentException("could not find the sequence " + sequenceKey);
        }
        return sequenceKey;
    }

    protected String checkSequence(String sequenceKey) throws IllegalArgumentException, TopiaException {
        if (!this.sequences.containsKey(sequenceKey)) {
            throw new IllegalArgumentException("could not find the sequence " + sequenceKey);
        }
        return sequenceKey;
    }

    protected void initMapping(Properties props) throws IOException {
        this.schema = props.containsKey(SCHEMA_FORMAT) ? props.getProperty(SCHEMA_FORMAT) + DOT : "";
        Pattern classPattern = Pattern.compile(CLASS_PATTERN);
        Pattern dbNameAttributePattern = Pattern.compile(DBNAME_ATTRIBUTE_PATTERN);
        Pattern sequenceAttributePattern = Pattern.compile(SEQUENCE_ATTRIBUTE_PATTERN);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String attribute;
            String clazz;
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            Matcher matcher = dbNameAttributePattern.matcher(key);
            if (matcher.matches()) {
                clazz = matcher.group(1);
                attribute = matcher.group(2);
                this.mappingBeanToDb.put(clazz + DOT + attribute, value);
                continue;
            }
            matcher = classPattern.matcher(key);
            if (matcher.matches()) {
                clazz = matcher.group(1);
                this.mappingBeanToDb.put(clazz, value);
                continue;
            }
            matcher = sequenceAttributePattern.matcher(key);
            if (!matcher.matches()) continue;
            clazz = matcher.group(1);
            attribute = matcher.group(2);
            try {
                boolean useSequence = Boolean.valueOf(value);
                if (!useSequence) continue;
                Class<?> value1 = Class.forName(clazz);
                if (TopiaEntity.class.isAssignableFrom(value1)) {
                    this.sequences.put(clazz + DOT + attribute, value1);
                    continue;
                }
                log.warn((Object)("can not create a sequence on a non TopiaEntity class " + clazz));
            }
            catch (Exception e) {
                log.warn((Object)("could not convert sequence value for entry " + key + " for reason " + e.getMessage()));
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        if (this.mappingBeanToDb != null) {
            this.mappingBeanToDb.clear();
        }
        if (this.sequences != null) {
            this.sequences.clear();
        }
    }
}

