/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaDatabase;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.test.entities.PersonImpl;
import org.nuiton.topiatest.Personne;

public class TopiaUtilTest {
    protected static final String PERSON_ID = "org.nuiton.topiatest.Personne#1226701039001#0.6502325993664224";
    protected static final String PERSON_ID2 = "org.nuiton.topiatest.Personne#1226701039001#0.6502325993664999";
    @Rule
    public final TopiaDatabase db = new TopiaDatabase();

    @Test
    public void testGetTopiaIdPattern() throws Exception {
        String expected = "org\\.nuiton\\.topiatest\\.Personne#(?:\\d+?)#(?:\\d+)\\.(?:\\d+)";
        String actual = TopiaUtil.getTopiaIdPattern(Personne.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetTopiaPattern() throws Exception {
        String expected = "(\\d+)-(org\\.nuiton\\.topiatest\\.Personne#(?:\\d+?)#(?:\\d+)\\.(?:\\d+))-(org\\.nuiton\\.topiatest\\.Personne#(?:\\d+?)#(?:\\d+)\\.(?:\\d+))(.*)";
        Pattern pattern = TopiaUtil.getTopiaPattern((String)"(\\d+)-%1$s-%1$s(.*)", (Class[])new Class[]{Personne.class});
        Assert.assertEquals((Object)expected, (Object)pattern.toString());
        String expression = "123-org.nuiton.topiatest.Personne#1226701039001#0.6502325993664224-org.nuiton.topiatest.Personne#1226701039001#0.6502325993664999-afterall";
        Matcher matcher = pattern.matcher(expression);
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertTrue((boolean)matcher.matches());
        Assert.assertEquals((long)4L, (long)matcher.groupCount());
        Assert.assertEquals((Object)"123", (Object)matcher.group(1));
        Assert.assertEquals((Object)PERSON_ID, (Object)matcher.group(2));
        Assert.assertEquals((Object)PERSON_ID2, (Object)matcher.group(3));
        Assert.assertEquals((Object)"-afterall", (Object)matcher.group(4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSchemaExistFailed() throws Exception {
        TopiaUtil.isSchemaExist((TopiaContext)this.db.getRootCtxt(), (String)"fake");
    }

    @Test
    public void testIsSchemaExist() throws Exception {
        TopiaContext rootContext = this.db.getRootCtxt();
        boolean actual = TopiaUtil.isSchemaExist((TopiaContext)rootContext, (String)PersonImpl.class.getName());
        Assert.assertFalse((boolean)actual);
        TopiaContext tx = rootContext.beginTransaction();
        tx.createSchema();
        actual = TopiaUtil.isSchemaExist((TopiaContext)rootContext, (String)PersonImpl.class.getName());
        Assert.assertTrue((boolean)actual);
    }
}

