/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.PropertyValueException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.NaturalizedEntity;
import org.nuiton.topiatest.NaturalizedEntityDAO;

public class NaturalIdTest {
    private static final Log log = LogFactory.getLog(NaturalIdTest.class);
    protected static File testBasedir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        testBasedir = TestHelper.getTestBasedir(NaturalIdTest.class);
    }

    protected TopiaContext initTopiaContext(String testName) throws IOException, TopiaNotFoundException {
        TopiaContext root = TestHelper.initTopiaContext(testBasedir, "/TopiaContextImpl.properties", testName);
        return root;
    }

    @Test
    public void testCreateSucessfull() throws Exception {
        log.debug((Object)"Test naturalId : create succesfull");
        TopiaContext root = this.initTopiaContext("createSucessfull");
        TopiaContext transaction = root.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        dao.create(new Object[]{"naturalIdNotNull", 5, "naturalIdNull", "str"});
        transaction.commitTransaction();
        dao.create(new Object[]{"naturalIdNotNull", 3});
        transaction.commitTransaction();
        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testCreateFailed() throws Exception {
        log.debug((Object)"Test naturalId : create failed");
        TopiaContext root = this.initTopiaContext("createFailed");
        TopiaContext transaction = root.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        try {
            dao.create(new Object[0]);
            transaction.commitTransaction();
        }
        catch (PropertyValueException eee) {
            Assert.assertEquals((Object)"naturalIdNotNull", (Object)eee.getPropertyName());
        }
        transaction.closeContext();
        root.closeContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateFailed() throws Exception {
        log.debug((Object)"Test naturalId : update failed");
        TopiaContext root = this.initTopiaContext("updateFailed");
        TopiaContext transaction = root.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        NaturalizedEntity entity = (NaturalizedEntity)dao.create(new Object[]{"naturalIdNotNull", 5, "naturalIdNull", "str"});
        transaction.commitTransaction();
        try {
            entity.setNaturalIdNotNull(8);
            transaction.commitTransaction();
        }
        catch (TopiaException eee) {
            Assert.assertEquals((Object)"org.hibernate.HibernateException", (Object)eee.getCause().getClass().getName());
        }
        finally {
            transaction.closeContext();
            root.closeContext();
        }
    }

    @Test
    public void testFindByNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : findByNaturalId");
        TopiaContext root = this.initTopiaContext("findByNaturalId");
        TopiaContext transaction = root.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        NaturalizedEntity entity = (NaturalizedEntity)dao.create(new Object[]{"naturalIdNotNull", 5, "naturalIdNull", "str"});
        transaction.commitTransaction();
        Object result = dao.findByNaturalId(5, "str");
        Assert.assertEquals((Object)entity, result);
        transaction.closeContext();
        root.closeContext();
    }

    @Test
    public void testExistNaturalId() throws Exception {
        log.debug((Object)"Test naturalId : existNaturalId");
        TopiaContext root = this.initTopiaContext("existNaturalId");
        TopiaContext transaction = root.beginTransaction();
        NaturalizedEntityDAO dao = TopiaTestDAOHelper.getNaturalizedEntityDAO(transaction);
        dao.create(new Object[]{"naturalIdNotNull", 5, "naturalIdNull", "str"});
        transaction.commitTransaction();
        boolean result = dao.existByNaturalId(5, "str");
        Assert.assertTrue((boolean)result);
        result = dao.existByNaturalId(8, "str");
        Assert.assertFalse((boolean)result);
        transaction.closeContext();
        root.closeContext();
    }
}

