/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: FakeService.java 1963 2010-05-14 14:18:23Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.3/topia-persistence/src/test/java/org/nuiton/topiatest/service/FakeService.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.topiatest.service;

import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaContextImplTest;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaService;

/**
 * FakeService which implements {@link TopiaService} to test existing service
 * from {@link TopiaContextImplTest#testGetServices()}. This fake service
 * doesn't contains property SERVICE_NAME used by {@link
 * TopiaContextImpl#serviceEnabled(Class)}.
 * <p/>
 * Created: 10 mai 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: FakeService.java 1963 2010-05-14 14:18:23Z tchemit $
 */
public class FakeService implements TopiaService {

    @Override
    public String getServiceName() {
        return "fake";
    }

    @Override
    public Class<?>[] getPersistenceClasses() {
        return new Class<?>[0];
    }

    @Override
    public boolean preInit(TopiaContextImplementor context) {
        return true;
    }

    @Override
    public boolean postInit(TopiaContextImplementor context) {
        return true;
    }
}
