/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EntityAbstractTransformer.java 2071 2010-07-11 07:45:36Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.1/topia-persistence/src/main/java/org/nuiton/topia/generator/EntityAbstractTransformer.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.generator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.*;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.*;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;




/**
 * Created: 14 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Id: EntityAbstractTransformer.java 2071 2010-07-11 07:45:36Z tchemit $
 * @since 2.3.0
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityAbstractTransformer"
 * @deprecated since 2.4 : all transformations needed for Entity is in {@link EntityTransformer} included in {@link TopiaMetaTransformer}
 */
@Deprecated
public class EntityAbstractTransformer extends ObjectModelTransformerToJava {

    /**
     * Logger
     */
    private static final Log log =
            LogFactory.getLog(EntityAbstractTransformer.class);

    @Override
    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype(STEREOTYPE_ENTITY)) {
            return;
        }

        String clazzName = clazz.getName();
        String clazzFQN = TopiaGeneratorUtil.getSimpleName(
                clazz.getQualifiedName());

        ObjectModelClass result;

        if (log.isDebugEnabled()) {
            log.debug("for entity : " + clazz.getQualifiedName());
        }

        result = createAbstractClass(clazzName + "Abstract",
                clazz.getPackageName());

        addInterface(result, clazzName);

        addImport(result, ArrayList.class);
        addImport(result, List.class);
        addImport(result, ToStringBuilder.class);
        addImport(result, TopiaEntity.class);
        addImport(result, TopiaContextImplementor.class);
        
        String prefix = getConstantPrefix(clazz, "");

        if (StringUtils.isEmpty(prefix)) {

            // no specific prefix, so no prefix
            if (log.isWarnEnabled()) {
                log.warn("[" + clazz.getName() + "] Will generate constants with NO prefix, not a good idea...");
            }
        }

        setConstantPrefix(prefix);
        
        // javadoc

        StringBuilder doc = new StringBuilder();
        doc.append("Implantation POJO pour l'entité {@link ");
        doc.append(StringUtils.capitalize(clazzFQN));
        doc.append("}\n");

        {
            String dbName = clazz.getTagValue(TAG_DB_NAME);
            if (dbName != null) {
                doc.append("<p>Nom de l'entité en BD : ");
                doc.append(dbName);
                doc.append(".</p>");
            }
        }

        setDocumentation(result, doc.toString());

        // super classes

        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            String extendClass = parent.getQualifiedName();
            //Si une des classes parentes définies des méthodes abstraites, son
            // impl ne sera pas créé
            boolean abstractParent = shouldBeAbstract(parent);
            if (parent.hasStereotype(STEREOTYPE_ENTITY)) {
                if (abstractParent) {
                    extendClass += "Abstract";
                } else {
                    extendClass += "Impl";
                }
            }
            setSuperClass(result, extendClass);
        }

        if (result.getSuperclasses().isEmpty()) {
            setSuperClass(result, TopiaEntityAbstract.class);
        }

        // serialVersionUID

        String svUID = TopiaGeneratorUtil.findTagValue("serialVersionUID",
                clazz, model);
        if (svUID != null) {
            addAttribute(result, "serialVersionUID", long.class, svUID,
                    ObjectModelModifier.PRIVATE,
                    ObjectModelModifier.STATIC,
                    ObjectModelModifier.FINAL);

        }

        ObjectModelParameter attr2;

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }

            String type;
            String name;

            if (!attr.hasAssociationClass()) {
                String attrName = attr.getName();
                name = attrName;
                type = attr.getType();
//                type = TopiaGeneratorUtil.getSimpleName(attr.getType());
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                //TODO THIMEL : Je pense que les
                // GeneratorUtil.toLowerCaseFirstLetter sont inutiles
                // ici, ou alors il faudrait le faire partout
                name = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                type = attr.getAssociationClass().getQualifiedName();
//                type = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());
            }

            if (GeneratorUtil.isNMultiplicity(attr)) {
                String collectionType =
                        TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                type = collectionType + '<' + type + '>';
            }

            String attrVisibility = attr.getVisibility();

            attr2 = addAttribute(result, name, type, null,
                    ObjectModelModifier.toValue(attrVisibility),
                    ObjectModelModifier.PROTECTED
            );

            doc = new StringBuilder();

            if (TopiaGeneratorUtil.hasDocumentation(attr) ||
                    attr.hasTagValue(TAG_DB_NAME)) {
                if (TopiaGeneratorUtil.hasDocumentation(attr)) {
                    String attrDocumentation = attr.getDocumentation();
                    doc.append(attrDocumentation).append('\n');
                }
                if (attr.hasTagValue(TAG_DB_NAME)) {
                    String dbName =
                            attr.getTagValue(TAG_DB_NAME);
                    doc.append("Nom de l'attribut en BD : ");
                    doc.append(dbName);
                    doc.append('\n');
                }
            }

            setDocumentation(attr2, doc.toString());


            if (attr.hasTagValue(TAG_ANNOTATION)) {
                String annotation =  attr.getTagValue(TAG_ANNOTATION);
                //FIXME Make annotation works...
                //TODO tchemit 20100513 Test it still works
                addAnnotation(result, attr2, annotation);
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc =
                    (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                    String attrName = attr.getName();
                    addAttribute(result,
                            GeneratorUtil.toLowerCaseFirstLetter(attrName),
                            attrType, null,
                            ObjectModelModifier.toValue(attrVisibility));
                }
            }
        }

        ObjectModelOperation op = addOperation(result, "update", "void",
                ObjectModelModifier.PUBLIC);
        addException(op, TopiaException.class);
        setOperationBody(op, ""
+"\n"
+"        ((TopiaContextImplementor)getTopiaContext()).getDAO("+clazzName+".class).update(this);\n"
+""
        );

        op = addOperation(result, "delete", "void", ObjectModelModifier.PUBLIC);
        addException(op, TopiaException.class);
        setOperationBody(op, ""
+"\n"
+"        ((TopiaContextImplementor)getTopiaContext()).getDAO("+clazzName+".class).delete(this);\n"
+""
        );

        generateAcceptMethod(result, clazz);

        generateAggregateMethod(result, clazz);

        generateCompositeMethod(result, clazz);


        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)))
            {
                continue;
            }

            transformAttribute(result, attr, reverse);
        }


        //Méthodes d'accès aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            generateAssociationAccessors(result,
                    (ObjectModelAssociationClass) clazz);
        }

        generateAbstractMethods(result, clazz);

        boolean doGenerateToString = TopiaGeneratorUtil.generateToString(clazz,
                model);
        if (doGenerateToString) {
            generateToStringMethod(result, clazz);
        }

        String i18nPrefix = TopiaGeneratorUtil.getI18nPrefix(clazz, model);
        if (!StringUtils.isEmpty(i18nPrefix)) {
            // generate i18n prefix
            generateI18n(result, i18nPrefix, clazz);
        }
    }

    protected void transformAttribute(ObjectModelClass result,
                                      ObjectModelAttribute attr,
                                      ObjectModelAttribute reverse) {

        String attrName = attr.getName();
        String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
        addImport(result, attrType);

        attrType = TopiaGeneratorUtil.getSimpleName(attrType);

        ObjectModelOperation op;

        if (!GeneratorUtil.isNMultiplicity(attr)) {

            if (attr.hasAssociationClass()) {
                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                addImport(result, assocClassFQN);
                assocClassFQN = TopiaGeneratorUtil.getSimpleName(assocClassFQN);
                String name = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);

                // setXXX

                op = addOperation(result,
                        "set" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, assocClassFQN, "association");
                setOperationBody(op, ""
+"\n"
+"        "+assocClassFQN+" _oldValue = this."+name+";\n"
+"        fireOnPreWrite("+getConstantName(name)+", _oldValue, association);\n"
+"        this."+name+" = association;\n"
+"        fireOnPostWrite("+getConstantName(name)+", _oldValue, association);\n"
+""
                );

                // getXXX

                op = addOperation(result,
                        "get" + StringUtils.capitalize(assocAttrName),
                        assocClassFQN, ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        return "+name+";\n"
+""
                );
            } else {

                // setXXX

                op = addOperation(result,
                        "set" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, attrType, "value");
                setOperationBody(op, ""
+"\n"
+"        "+attrType+" _oldValue = this."+attrName+";\n"
+"        fireOnPreWrite("+getConstantName(attrName)+", _oldValue, value);\n"
+"        this."+attrName+" = value;\n"
+"        fireOnPostWrite("+getConstantName(attrName)+", _oldValue, value);\n"
+""

                );

                // getXXX

                op = addOperation(result,
                        "get" + StringUtils.capitalize(attrName),
                        attrType,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        fireOnPreRead("+getConstantName(attrName)+", "+attrName+");\n"
+"        "+attrType+" result = this."+attrName+";\n"
+"        fireOnPostRead("+getConstantName(attrName)+", "+attrName+");\n"
+"        return result;\n"
+""
                );
            }
        } else { //NMultiplicity
            String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
            String collectionObject = TopiaGeneratorUtil.getNMultiplicityObjectType(attr);
            addImport(result, collectionInterface);
            addImport(result, collectionObject);
            collectionInterface = TopiaGeneratorUtil.getSimpleName(collectionInterface);
            collectionObject = getSimpleName(collectionObject);

            if (!attr.hasAssociationClass()) {
                //Méthodes remplacées par des accesseurs sur les classes d'assoc

                // addXXX

                op = addOperation(result,
                        "add" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, attrType, attrName);
                StringBuilder body = new StringBuilder();

                body.append(""
+"    \n"
+"        fireOnPreWrite("+getConstantName(attrName)+", null, "+attrName+");\n"
+"        if (this."+attrName+" == null) {\n"
+"            this."+attrName+" = new "+collectionObject+"<"+attrType+">();\n"
+"        }\n"
+""
                );

                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    String reverseAttrType = TopiaGeneratorUtil.getSimpleName(reverse.getType());
                    if (!GeneratorUtil.isNMultiplicity(reverse)) {
                        body.append(""
+"        "+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(this);\n"
+""
                        );
                    } else {
                        body.append(""
+"        if ("+attrName+".get"+StringUtils.capitalize(reverseAttrName)+"() == null) {\n"
+"            "+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(new "+collectionObject+"<"+reverseAttrType+">());\n"
+"        }\n"
+"        "+attrName+".get"+StringUtils.capitalize(reverseAttrName)+"().add(this);\n"
+""
                        );
                    }
                }
                body.append(""
+"        this."+attrName+".add("+attrName+");\n"
+"        fireOnPostWrite("+getConstantName(attrName)+", this."+attrName+".size(), null, "+attrName+");\n"
+""
                );
                setOperationBody(op, body.toString());

                // addAllXXX

                op = addOperation(result,
                        "addAll" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, collectionInterface + '<' + attrType + '>', "values");

                setOperationBody(op, ""
+"\n"
+"        if (values == null) {\n"
+"            return;\n"
+"        }\n"
+"        for ("+attrType+" item : values) {\n"
+"            add"+StringUtils.capitalize(attrName)+"(item);\n"
+"        }\n"
+""
                );

                if (!isPrimitiveType(attr) && !isDateType(attr)) {

                    op = addOperation(result,
                            "get" + StringUtils.capitalize(attrName) + "ByTopiaId",
                            attrType,
                            ObjectModelModifier.PUBLIC);
                    addParameter(op, String.class, "topiaId");
                    setOperationBody(op, ""
+"\n"
+"        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId("+attrName+", topiaId);\n"
+" "
                    );

                }

                // setXXX

                op = addOperation(result,
                        "set" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, collectionInterface + '<' + attrType + '>', "values");

                setOperationBody(op, ""
+"\n"
+"        "+collectionInterface+"<"+attrType+"> _oldValue = "+attrName+";\n"
+"        fireOnPreWrite("+getConstantName(attrName)+", _oldValue, values);\n"
+"        "+attrName+" = values;\n"
+"        fireOnPostWrite("+getConstantName(attrName)+", _oldValue, values);\n"
+""
                );


                // removeXXX


                op = addOperation(result,
                        "remove" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, attrType, "value");
                body = new StringBuilder();

                body.append(""
+"\n"
+"        fireOnPreWrite("+getConstantName(attrName)+", value, null);\n"
+"        if ((this."+attrName+" == null) || (!this."+attrName+".remove(value))) {\n"
+"            throw new IllegalArgumentException(\"List does not contain given element\");\n"
+"        }\n"
+""
                );

                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    if (!GeneratorUtil.isNMultiplicity(reverse)) {
                        body.append(""
+"        value.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n"
+""
                        );
                    } else {
                        body.append(""
+"        value.get"+StringUtils.capitalize(reverseAttrName)+"().remove(this);\n"
+""
                        );
                    }
                }
                body.append(""
+"        fireOnPostWrite("+getConstantName(attrName)+", this."+attrName+".size()+1, value, null);\n"
+""
                );
                setOperationBody(op, body.toString());


                // clearXXX

                op = addOperation(result,
                        "clear" + StringUtils.capitalize(attrName),
                        "void",
                        ObjectModelModifier.PUBLIC);

                body = new StringBuilder();

                body.append(""
+"\n"
+"        if (this."+attrName+" == null) {\n"
+"            return;\n"
+"        }\n"
+""
                );

                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    body.append(""
+"        for ("+attrType+" item : this."+attrName+") {\n"
+""
                    );
                    if (!GeneratorUtil.isNMultiplicity(reverse)) {
                        body.append(""
+"            item.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n"
+""
                        );
                    } else {
                        body.append(""
+"            item.get"+StringUtils.capitalize(reverseAttrName)+"().remove(this);\n"
+""
                        );
                    }
                    body.append(""
+"        }\n"
+""
                    );
                }
                body.append(""
+"        "+collectionInterface+"<"+attrType+"> _oldValue = new "+collectionObject+"<"+attrType+">(this."+attrName+");\n"
+"        fireOnPreWrite("+getConstantName(attrName)+", _oldValue, this."+attrName+");\n"
+"        this."+attrName+".clear();\n"
+"        fireOnPostWrite("+getConstantName(attrName)+", _oldValue, this."+attrName+");\n"
+""
                );

                setOperationBody(op, body.toString());

            } else {


                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
//                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());

                // addXXX

                op = addOperation(result,
                        "add" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, assocClassFQN, "value");

                StringBuilder body = new StringBuilder();

                body.append(""
+"\n"
+"        fireOnPreWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", null, value);\n"
+"        if (this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n"
+"            this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = new "+collectionObject+"<"+assocClassFQN+">();\n"
+"        }\n"
+""
                );
                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    body.append(""
+"        value.set"+StringUtils.capitalize(reverseAttrName)+"(this);\n"
+""
                    );
                }
                body.append(""
+"        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".add(value);\n"
+"        fireOnPostWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size(), null, value);\n"
+""
                );
                setOperationBody(op, body.toString());


                if (!isPrimitiveType(attr) && !isDateType(attr)) {

                    // getXXXByTopiaId

                    op = addOperation(result,
                            "get" + StringUtils.capitalize(assocAttrName) + "ByTopiaId",
                            assocClassFQN,
                            ObjectModelModifier.PUBLIC);
                    addParameter(op, String.class, "topiaId");
                    setOperationBody(op, ""
+"\n"
+"        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId("+assocAttrName+", topiaId);\n"
+""
                    );

                }

                // addAllXXX

                op = addOperation(result,
                        "addAll" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                setOperationBody(op, ""
+"\n"
+"        if (values == null) {\n"
+"            return;\n"
+"        }\n"
+"        for ("+assocClassFQN+" item : values) {\n"
+"            add"+StringUtils.capitalize(assocAttrName)+"(item);\n"
+"        }\n"
+""
                );

                // setXXX

                op = addOperation(result,
                        "set" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, collectionInterface + '<' + assocClassFQN + '>', "values");
                setOperationBody(op, ""
+"\n"
+"//        clear"+StringUtils.capitalize(assocAttrName)+"();\n"
+"//        addAll"+StringUtils.capitalize(assocAttrName)+"(values);\n"
+"// FIXME\n"
+"        "+collectionInterface+"<"+assocClassFQN+"> _oldValue = "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+"        fireOnPreWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", _oldValue, values);\n"
+"        "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = values;\n"
+"        fireOnPostWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", _oldValue, values);\n"
+""
                );

                // removeXXX

                op = addOperation(result,
                        "remove" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);
                addParameter(op, assocClassFQN, "value");

                body = new StringBuilder();

                body.append(""
+"\n"
+"        fireOnPreWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", value, null);\n"
+"        if ((this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) || (!this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".remove(value))) {\n"
+"            throw new IllegalArgumentException(\"List does not contain given element\");\n"
+"        }\n"
+""
                );
                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    body.append(""
+"        value.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n"
+""
                    );
                }
                body.append(""
+"        fireOnPostWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size()+1, value, null);\n"
+""
                );

                setOperationBody(op, body.toString());

                // clearXXX

                op = addOperation(result,
                        "clear" + StringUtils.capitalize(assocAttrName),
                        "void",
                        ObjectModelModifier.PUBLIC);

                body = new StringBuilder();

                body.append(""
+"\n"
+"        if (this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n"
+"            return;\n"
+"        }\n"
+""
                );

                if (reverse != null && (reverse.isNavigable() ||
                        hasUnidirectionalRelationOnAbstractType(attr, model))) {
                    String reverseAttrName = reverse.getName();
                    body.append(""
+"        for ("+assocClassFQN+" item : this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+") {\n"
+"            item.set"+StringUtils.capitalize(reverseAttrName)+"(null);\n"
+"        }\n"
+""
                    );
                }
                body.append(""
+"        "+collectionInterface+"<"+assocClassFQN+"> _oldValue = new "+collectionObject+"<"+assocClassFQN+">(this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+");\n"
+"        fireOnPreWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", _oldValue, null);\n"
+"        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".clear();\n"
+"        fireOnPostWrite("+getConstantName(GeneratorUtil.toLowerCaseFirstLetter(assocAttrName))+", _oldValue, null);\n"
+""
                );
                setOperationBody(op, body.toString());
            }

            if (!attr.hasAssociationClass()) {

                // getXXX

                op = addOperation(result,
                        "get" + StringUtils.capitalize(attrName),
                        collectionInterface + '<' + attrType + '>',
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        return "+attrName+";\n"
+""
                );

                // sizeXXX

                op = addOperation(result,
                        "size" + StringUtils.capitalize(attrName),
                        int.class,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        if ("+attrName+" == null) {\n"
+"            return 0;\n"
+"        }\n"
+"        return "+attrName+".size();\n"
+""
                );

                // isXXXEmpty

                op = addOperation(result,
                        "is" + StringUtils.capitalize(attrName) + "Empty",
                        boolean.class,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        int size = size"+StringUtils.capitalize(attrName)+"();\n"
+"        return size == 0;\n"
+""
                );

            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
//                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(attr.getAssociationClass().getQualifiedName());

                // getXXX

                op = addOperation(result,
                        "get" + StringUtils.capitalize(assocAttrName),
                        collectionInterface + '<' + assocClassFQN + '>',
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n"
+""
                );

                // getXXX

                op = addOperation(result,
                        "get" + StringUtils.capitalize(assocAttrName),
                        assocClassFQN,
                        ObjectModelModifier.PUBLIC);
                addParameter(op, attrType, "value");
                setOperationBody(op, ""
+"\n"
+"        if (value == null || "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n"
+"            return null;\n"
+"        }\n"
+"        for ("+assocClassFQN+" item : "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+") {\n"
+"            if (value.equals(item.get"+StringUtils.capitalize(attrName)+"())) {\n"
+"                return item;\n"
+"            }\n"
+"        }\n"
+"        return null;\n"
+""
                );


                // sizeXXX

                op = addOperation(result,
                        "size" + StringUtils.capitalize(assocAttrName),
                        int.class,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        if ("+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" == null) {\n"
+"            return 0;\n"
+"        }\n"
+"        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+".size();\n"
+""
                );

                //isXXXEmpty

                op = addOperation(result,
                        "is" + StringUtils.capitalize(assocAttrName) + "Empty",
                        boolean.class,
                        ObjectModelModifier.PUBLIC);
                setOperationBody(op, ""
+"\n"
+"        int size = size"+StringUtils.capitalize(assocAttrName)+"();\n"
+"        return size == 0;\n"
+""
                );

            }
        }
    }

    protected void generateAssociationAccessors(
            ObjectModelClass result,
            ObjectModelAssociationClass assoc) {
        for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
            if (attr != null) {
                String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                String attrName = attr.getName();
                generateAssociationAccessors(result, attrName, attrType);
//                   //Ne sert plus à rien normalement avec la navigabilité
//                   ObjectModelAttribute reverse = attr.getReverseAttribute();
//                   if (reverse == null) {
//                       attrType = ((ObjectModelClassifier)attr.getDeclaringElement()).getQualifiedName();
//                       attrName = attr.getDeclaringElement().getName();
//                       generateAssociationAccessors(output, attrName, attrType);
//                   }
            }
        }
    }

    protected void generateToStringMethod(ObjectModelClass result,
                                          ObjectModelClass clazz) {
        if (log.isDebugEnabled()) {
            log.debug("generate toString method for clazz " +
                    clazz.getQualifiedName());
        }
        ObjectModelOperation op = addOperation(result,
                "toString",
                String.class,
                ObjectModelModifier.PUBLIC);
        addAnnotation(result, op, Override.class.getSimpleName());
        StringBuilder body = new StringBuilder();


        body.append(""
+"\n"
+"        String result = new ToStringBuilder(this).\n"
+""
        );
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null &&
                    attrEntity.hasStereotype(STEREOTYPE_ENTITY);
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (isEntity && (reverse == null || !reverse.isNavigable())
                    && !attr.hasAssociationClass() || !isEntity) {
                String attrName = attr.getName();
                body.append(""
+"            append("+getConstantName(attrName)+", this."+attrName+").\n"
+""
                );
            }
        }
        body.append(""
+"         toString();\n"
+"        return result;\n"
+""
        );
        setOperationBody(op, body.length() == 0 ? " " : body.toString());

    }

    protected void generateCompositeMethod(ObjectModelClass result,
                                           ObjectModelClass clazz) {

        ObjectModelOperation op = addOperation(result,
                "getComposite",
                List.class.getName() + '<' + TopiaEntity.class.getName() + '>',
                ObjectModelModifier.PUBLIC);
        addException(op, TopiaException.class);
        StringBuilder body = new StringBuilder();
        body.append(""
+"\n"
+"        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n"
+"\n"
+"        // pour tous les attributs rechecher les composites et les class d'asso\n"
+"        // on les ajoute dans tmp\n"
+""
        );
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() &&
                    attr.getClassifier().hasStereotype(
                            STEREOTYPE_ENTITY)) {
                if (attr.isComposite()) {
                    String attrName = attr.getName();
                    String getterName = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
                        body.append(""
+"        if ("+getterName+"() != null) {\n"
+"              tmp.addAll("+getterName+"());\n"
+"           }\n"
+""
                        );
                    } else {
                        body.append(""
+"        tmp.add("+getterName+"());\n"
+""
                        );
                    }
                } else if (attr.hasAssociationClass()) {
                    String assocAttrName = GeneratorUtil.getAssocAttrName(
                            attr);
                    String assocClassFQN = TopiaGeneratorUtil.getSimpleName(
                            attr.getAssociationClass().getQualifiedName());
                    String ref = "this." + GeneratorUtil.toLowerCaseFirstLetter(
                            assocAttrName);
                    if (!GeneratorUtil.isNMultiplicity(attr)) {
                        body.append(""
+"\n"
+"        if ("+ref+" != null) {\n"
+"            tmp.add("+ref+");\n"
+"        }\n"
+""
                        );
                    } else {
                        ObjectModelAttribute reverse = attr.getReverseAttribute();
                        String reverseAttrName = reverse.getName();
                        // On utilise pas l'attribut car il est potentiellement
                        // pas a jour, car  pour les asso avec cardinalité
                        // personne ne fait de add. Ce qui est normal, mais
                        // pour pouvoir faire tout de meme des delete en cascade
                        // sur les asso, le champs est dans le mapping
                        // hibernate et donc il le faut aussi dans la classe
                        // sinon hibernate rale lorsqu'il charge l'objet
//                        if (<%=ref%> != null) {
//                            tmp.addAll(<%=ref%>);
//                        }
                        body.append(""
+"\n"
+"        {\n"
+"            org.nuiton.topia.persistence.TopiaDAO<"+assocClassFQN+"> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO("+assocClassFQN+".class);\n"
+"            List<"+assocClassFQN+"> findAllByProperties = dao.findAllByProperties(\""+reverseAttrName+"\", this);\n"
+"            if (findAllByProperties != null) {\n"
+"                tmp.addAll(findAllByProperties);\n"
+"            }\n"
+"        }\n"
+""
                        );
                    }
                }
            }
        }
        body.append(""
+"\n"
+"        // on refait un tour sur chaque entity de tmp pour recuperer leur\n"
+"        // composite\n"
+"        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n"
+"        for (TopiaEntity entity : tmp) {\n"
+"            if (entity != null) {\n"
+"                result.add(entity);\n"
+"                result.addAll(entity.getComposite());\n"
+"            }\n"
+"        }\n"
+"\n"
+"        return result;\n"
+""
        );

        setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAggregateMethod(ObjectModelClass result,
                                           ObjectModelClass clazz) {

        ObjectModelOperation op = addOperation(result,
                "accept",
                List.class.getName() + '<' + TopiaEntity.class.getName() + '>',
                ObjectModelModifier.PUBLIC);
        addException(op, TopiaException.class);

        StringBuilder body = new StringBuilder();
        body.append(""
+"\n"
+"        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();\n"
+"\n"
+"        // pour tous les attributs rechecher les composites et les class d'asso\n"
+"        // on les ajoute dans tmp\n"
+""
        );
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.referenceClassifier() &&
                    attr.getClassifier().hasStereotype(
                            STEREOTYPE_ENTITY)) {
                if (attr.isAggregate()) {
                    String attrName = attr.getName();
                    String getterName = "get" + StringUtils.capitalize(attrName);
                    if (GeneratorUtil.isNMultiplicity(attr)) {
                        body.append(""
+"        tmp.addAll("+getterName+"());\n"
+""
                        );
                    } else {
                        body.append(""
+"        tmp.add("+getterName+"());\n"
+""
                        );
                    }
                }
            }
        }
        body.append(""
+"\n"
+"        // on refait un tour sur chaque entity de tmp pour recuperer leur\n"
+"        // composite\n"
+"        List<TopiaEntity> result = new ArrayList<TopiaEntity>();\n"
+"        for (TopiaEntity entity : tmp) {\n"
+"            result.add(entity);\n"
+"            result.addAll(entity.getAggregate());\n"
+"        }\n"
+"\n"
+"        return result;\n"
+""
        );

        setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }

    protected void generateAcceptMethod(ObjectModelClass result,
                                        ObjectModelClass clazz) {

        ObjectModelOperation op = addOperation(result,
                "accept",
                "void",
                ObjectModelModifier.PUBLIC);
        addException(op, TopiaException.class);
        setDocumentation(op, "Envoi via les methodes du visitor l'ensemble des " +
                "champs de l'entity\n" +
                "avec leur nom, type et valeur.");
        {
            ObjectModelParameter attr = addParameter(op, EntityVisitor.class,
                    "visitor");
            setDocumentation(attr, "le visiteur de l'entite.");
        }
        StringBuilder body = new StringBuilder();
        body.append(""
+"\n"
+"        visitor.start(this);\n"
+""
        );
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }

            if (!attr.hasAssociationClass()) {
                String attrType = TopiaGeneratorUtil.getSimpleName(attr.getType());
                String attrName = attr.getName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    body.append(""
+"        visitor.visit(this, "+getConstantName(attrName)+", "+attrType+".class, "+attrName+");\n"
+""
                    );
                } else {
                    String collectionType = TopiaGeneratorUtil.getSimpleName(
                            TopiaGeneratorUtil.getNMultiplicityInterfaceType(
                                    attr));
                    body.append(""
+"        visitor.visit(this, "+getConstantName(attrName)+", "+collectionType+".class, "+attrType+".class, "+attrName+");\n"
+""
                    );
                }
            } else {
                String assocAttrName = GeneratorUtil.getAssocAttrName(attr);
                assocAttrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
                String assocClassFQN = TopiaGeneratorUtil.getSimpleName(
                        attr.getAssociationClass().getQualifiedName());
                if (!GeneratorUtil.isNMultiplicity(attr)) {
                    body.append(""
+"        visitor.visit(this, "+getConstantName(assocAttrName)+", "+assocClassFQN+".class, "+assocAttrName+");\n"
+""
                    );
                } else {
                    String collectionType = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
                    body.append(""
+"        visitor.visit(this, "+getConstantName(assocAttrName)+", "+collectionType+".class, "+assocClassFQN+".class, "+assocAttrName+");\n"
+""
                    );
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrType = TopiaGeneratorUtil.getSimpleName(
                            attr.getType());
                    String attrName = attr.getName();
                    attrName = GeneratorUtil.toLowerCaseFirstLetter(attrName);
                    body.append(""
+"        visitor.visit(this, "+getConstantName(attrName)+", "+attrType+".class, "+attrName+");\n"
+""
                    );
                }
            }
        }
        body.append(""
+"        visitor.end(this);\n"
+""
        );

        setOperationBody(op, body.length() == 0 ? " " : body.toString());
    }


    private void generateAssociationAccessors(ObjectModelClass result,
                                              String name, String type) {
        ObjectModelOperation op;
        op = addOperation(result,
                "set" + StringUtils.capitalize(name),
                "void",
                ObjectModelModifier.PUBLIC);
        ObjectModelParameter param = addParameter(op, type, "value");
        setDocumentation(param, "La valeur de l'attribut " + name +
                " à positionner.");
        setOperationBody(op, ""
+"\n"
+"        "+type+" _oldValue = this."+GeneratorUtil.toLowerCaseFirstLetter(name)+";\n"
+"        fireOnPreWrite(\""+name+"\", _oldValue, value);\n"
+"        this."+GeneratorUtil.toLowerCaseFirstLetter(name)+" = value;\n"
+"        fireOnPostWrite(\""+name+"\", _oldValue, value);\n"
+""
        );

        op = addOperation(result,
                "get" + StringUtils.capitalize(name),
                type,
                ObjectModelModifier.PUBLIC);
        setOperationBody(op, ""
+"    \n"
+"        return "+GeneratorUtil.toLowerCaseFirstLetter(name)+";\n"
+""
        );

    }

    /**
     * Generate entity methods which have not a public visibility. In this case, they will not be
     * generated in the EntityInterface, so they will be generated here, in the EntityAbstract
     * with abstract modifier to keep consistency with the model.
     * @param result ObjectModelClass result corresponding to the EntityAbstract
     * @param clazz ObjectModelClass source from ObjectModel
     */
    private void generateAbstractMethods(ObjectModelClass result,
                                         ObjectModelClass clazz) {
        for (ObjectModelOperation op : clazz.getOperations()) {
            if (log.isDebugEnabled()) {
                log.debug("clazz : " + clazz.getQualifiedName() +
                        " - method : " + op.getName() +
                        " - visibility : " + op.getVisibility());
            }
            String visibility = op.getVisibility();
            ObjectModelModifier visibilityModifier = ObjectModelModifier.toValue(visibility);
            if (!visibilityModifier.equals(ObjectModelModifier.PUBLIC)) {
                addOperation(result,
                        op.getName(),
                        op.getReturnType(),
                        visibilityModifier,
                        ObjectModelModifier.ABSTRACT);
            }
        }
    }

    private void generateI18n(ObjectModelClass result, String i18nPrefix,
                              ObjectModelClass clazz) {

        StringBuilder buffer = new StringBuilder(300);
        addI18n(buffer, i18nPrefix, Introspector.decapitalize(clazz.getName()));
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            //TC-20100225 only treate navigable relations
            if (attr.isNavigable()) {
                addI18n(buffer, i18nPrefix, Introspector.decapitalize(attr.getName()));
            }
        }

        //FIXME : use a block extension for java
        ObjectModelOperation op = addBlock(result, ObjectModelModifier.STATIC);
        setOperationBody(op, buffer.toString());
    }

    private void addI18n(StringBuilder buffer, String i18nPrefix,
                         String suffix) {
        buffer.append("\n    org.nuiton.i18n.I18n.n_(\"");
        buffer.append(i18nPrefix);
        buffer.append(suffix);
        buffer.append("\");");
    }
}
