/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.Driver;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.framework.TopiaContextImpl;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaService;
import org.nuiton.topiatest.persistence.Entity1;
import org.nuiton.topiatest.persistence.Entity1Impl;
import org.nuiton.topiatest.service.FakeService;
import org.nuiton.topiatest.service.TestService;

public class TopiaContextImplTest {
    private static final Log log = LogFactory.getLog(TopiaContextImplTest.class);
    protected Properties properties = new Properties();

    @BeforeClass
    public static void setUpClass() throws Exception {
        I18n.init((Locale)Locale.FRENCH);
    }

    @Before
    public void setUp() throws Exception {
        this.properties.clear();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLoadServices() throws Exception {
        log.info((Object)"## testLoadServices");
        this.properties.setProperty("topia.service.test", TestService.class.getName());
        TopiaContextImpl context = new TopiaContextImpl();
        log.info((Object)"test 1 : load a simple TestService from properties");
        Map results = context.loadServices(this.properties);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertTrue((boolean)results.containsKey("test"));
        TopiaService service = (TopiaService)results.get("test");
        Assert.assertEquals(TestService.class, service.getClass());
        log.info((Object)"test 2 : load with wrong key : will display a WARN");
        this.properties.clear();
        this.properties.setProperty("topia.service.fake", TestService.class.getName());
        results = context.loadServices(this.properties);
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertFalse((boolean)results.containsKey("fake"));
        log.info((Object)"test 3 : load with fake service name : will display an ERROR");
        this.properties.clear();
        this.properties.setProperty("topia.service.test", "FAKE");
        results = context.loadServices(this.properties);
        Assert.assertEquals((long)0L, (long)results.size());
        Assert.assertFalse((boolean)results.containsKey("test"));
    }

    @Test
    public void testGetServices() throws Exception {
        log.info((Object)"## testGetServices");
        this.properties.setProperty("topia.service.test", TestService.class.getName());
        TopiaContextImpl context = new TopiaContextImpl(this.properties);
        TopiaContextImpl child = new TopiaContextImpl((TopiaContextImplementor)context);
        log.info((Object)"test 1 : with child context");
        Map test1 = child.getServices();
        Assert.assertEquals((long)1L, (long)test1.size());
        Assert.assertTrue((boolean)test1.containsKey("test"));
        log.info((Object)"test 2 : test serviceEnabled method");
        boolean test2 = child.serviceEnabled("test");
        Assert.assertTrue((boolean)test2);
        log.info((Object)"test 3 : test getService method");
        TopiaService test3 = child.getService("test");
        Assert.assertEquals(TestService.class, test3.getClass());
        log.info((Object)"test 4 : test serviceEnabled from class TestService");
        boolean test4 = child.serviceEnabled(TestService.class);
        Assert.assertTrue((boolean)test4);
        log.info((Object)"test 5 : test getService from class TestService");
        TestService test5 = (TestService)child.getService(TestService.class);
        Assert.assertNotNull((Object)test5);
        log.info((Object)"test 6 : test serviceEnabled error with class FakeService");
        this.properties.clear();
        this.properties.setProperty("topia.service.fake", FakeService.class.getName());
        TopiaContextImpl otherContext = new TopiaContextImpl(this.properties);
        boolean test6 = otherContext.serviceEnabled(FakeService.class);
        Assert.assertFalse((boolean)test6);
        log.info((Object)"test 7 : test getService with error TopiaNotFoundException : service not loaded");
        try {
            TestService test7 = (TestService)otherContext.getService(TestService.class);
        }
        catch (Exception eee) {
            log.error((Object)(eee.getClass().getSimpleName() + " : " + eee.getMessage()));
            Assert.assertEquals(TopiaNotFoundException.class, eee.getClass());
        }
    }

    @Test
    public void testContextHierarchy() throws Exception {
        log.info((Object)"## testContextHierarchy");
        TopiaContextImpl context = new TopiaContextImpl(this.properties);
        log.info((Object)"test 1 : constructor with parent context");
        TopiaContextImpl test1 = new TopiaContextImpl((TopiaContextImplementor)context);
        Assert.assertEquals((Object)context, (Object)test1.parentContext);
        log.info((Object)"test 2 : addChildContext");
        TopiaContextImpl test2 = new TopiaContextImpl(this.properties);
        TopiaContextImpl child2 = new TopiaContextImpl();
        test2.addChildContext((TopiaContextImplementor)child2);
        Assert.assertEquals((long)1L, (long)test2.childContext.size());
        log.info((Object)"test 3 : removeChildContext");
        TopiaContextImpl test3 = new TopiaContextImpl(this.properties);
        TopiaContextImpl child3 = new TopiaContextImpl((TopiaContextImplementor)test3);
        test3.childContext.add(child3);
        test3.removeChildContext((TopiaContextImplementor)child3);
        Assert.assertEquals((long)0L, (long)test3.childContext.size());
        test3.childContext.add(child3);
        test3.closed = true;
        test3.removeChildContext((TopiaContextImplementor)child3);
        Assert.assertEquals((long)1L, (long)test3.childContext.size());
        log.info((Object)"test 4 : getRootContext");
        TopiaContextImplementor test4 = child3.getRootContext();
        Assert.assertEquals((Object)test3, (Object)test4);
    }

    @Test
    public void testGetHibernateFactory() throws Exception {
        log.info((Object)"## testGetHibernateFactory");
        TopiaContextImpl context = new TopiaContextImpl();
        context.services = new HashMap();
        String basedir = System.getenv("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        log.debug((Object)("baseDir : " + basedir));
        File persistenceDir = new File(basedir, "target" + File.separator + "test-classes" + File.separator + "org" + File.separator + "nuiton" + File.separator + "topiatest" + File.separator + "persistence");
        log.debug((Object)("persistenceDir : " + persistenceDir));
        File resourcesDir = new File(basedir, "target" + File.separator + "test-classes");
        log.info((Object)"test 1 : load mappings from directory");
        this.properties.setProperty("topia.persistence.directories", persistenceDir.getAbsolutePath());
        context.config = this.properties;
        Configuration test1 = context.getHibernateConfiguration();
        PersistentClass persistentClass = test1.getClassMapping(Entity1Impl.class.getName());
        Assert.assertNotNull((Object)persistentClass);
        Assert.assertEquals(Entity1.class, (Object)persistentClass.getProxyInterface());
        log.info((Object)"test 2 : load mappings for all entities");
        context = new TopiaContextImpl();
        context.services = new HashMap();
        this.properties.clear();
        this.properties.setProperty("topia.persistence.classes", Entity1Impl.class.getName());
        context.config = this.properties;
        Configuration test2 = context.getHibernateConfiguration();
        persistentClass = test2.getClassMapping(Entity1Impl.class.getName());
        Assert.assertNotNull((Object)persistentClass);
        Assert.assertEquals(Entity1.class, (Object)persistentClass.getProxyInterface());
        log.info((Object)"test 3 : add properties from file");
        context = new TopiaContextImpl();
        context.services = new HashMap();
        this.properties.clear();
        this.properties.setProperty("topia.persistence.properties.file", resourcesDir + File.separator + "TopiaContextImpl.properties");
        context.config = this.properties;
        Configuration test3 = context.getHibernateConfiguration();
        Assert.assertEquals((Object)test3.getProperty("hibernate.connection.driver_class"), (Object)Driver.class.getName());
    }
}

