/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: TestUtils.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-persistence/src/test/java/org/nuiton/topiatest/TestUtils.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topiatest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaTestDAOHelper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * TestUtils
 * <p/>
 * Created: 18 févr. 2010
 *
 * @author fdesbois
 * @version $Revision: 1894 $
 *          <p/>
 *          Mise a jour: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 *          par : $Author: tchemit $
 */
@Ignore
public class TestUtils {

    /** Logger */
    private static final Log log = LogFactory.getLog(TestUtils.class);

    public static TopiaContext start(String dbname)
            throws IOException, TopiaNotFoundException {

        InputStream stream = TestUtils.class.getResourceAsStream(
                "/TopiaContextImpl.properties");

        Properties configuration = new Properties();

        configuration.load(stream);
        configuration.setProperty(
                "topia.persistence.classes",
                TopiaTestDAOHelper.getImplementationClassesAsString());

        // make sure we always use a different directory

        String dbPath = "target/surefire-data/" + dbname + '_' +
                        System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info("dbPath = " + dbPath);
        }
        configuration.setProperty(
                "hibernate.connection.url",
                "jdbc:h2:file:" + dbPath);
        return TopiaContextFactory.getContext(configuration);
    }
}
