package org.nuiton.topiatest.deletetest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class Party2Abstract extends TopiaEntityAbstract implements Party2 {

    protected Collection<Contact2> contacts;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Party2.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Party2.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, CONTACTS, Collection.class, Contact2.class, contacts);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * addContacts :
     * @param contacts 
     */

    public void addContacts(Contact2 contacts) {    
        fireOnPreWrite(CONTACTS, null, contacts);
        if (this.contacts == null) {
            this.contacts = new ArrayList<Contact2>();
        }
        if (contacts.getParty2() == null) {
            contacts.setParty2(new ArrayList<Party2>());
        }
        contacts.getParty2().add(this);
        this.contacts.add(contacts);
        fireOnPostWrite(CONTACTS, this.contacts.size(), null, contacts);
}

    /**
     * addAllContacts :
     * @param values 
     */

    public void addAllContacts(Collection<Contact2> values) {
        if (values == null) {
            return;
        }
        for (Contact2 item : values) {
            addContacts(item);
        }
}

    /**
     * getContactsByTopiaId :
     * @param topiaId 
     * @return Contact2 
     */

    public Contact2 getContactsByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(contacts, topiaId);
 }

    /**
     * setContacts :
     * @param values 
     */

    public void setContacts(Collection<Contact2> values) {
        Collection<Contact2> _oldValue = contacts;
        fireOnPreWrite(CONTACTS, _oldValue, values);
        contacts = values;
        fireOnPostWrite(CONTACTS, _oldValue, values);
}

    /**
     * removeContacts :
     * @param value 
     */

    public void removeContacts(Contact2 value) {
        fireOnPreWrite(CONTACTS, value, null);
        if ((this.contacts == null) || (!this.contacts.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.getParty2().remove(this);
        fireOnPostWrite(CONTACTS, this.contacts.size()+1, value, null);
}

    /**
     * clearContacts :
     */

    public void clearContacts() {
        if (this.contacts == null) {
            return;
        }
        for (Contact2 item : this.contacts) {
            item.getParty2().remove(this);
        }
        Collection<Contact2> _oldValue = new ArrayList<Contact2>(this.contacts);
        fireOnPreWrite(CONTACTS, _oldValue, this.contacts);
        this.contacts.clear();
        fireOnPostWrite(CONTACTS, _oldValue, this.contacts);
}

    /**
     * getContacts :
     * @return Collection<Contact2> 
     */

    public Collection<Contact2> getContacts() {
        return contacts;
}

    /**
     * sizeContacts :
     * @return int 
     */

    public int sizeContacts() {
        if (contacts == null) {
            return 0;
        }
        return contacts.size();
}

    /**
     * isContactsEmpty :
     * @return boolean 
     */

    public boolean isContactsEmpty() {
        int size = sizeContacts();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.party2");
    org.nuiton.i18n.I18n.n_("topia.test.common.contacts");
    }

} //Party2Abstract
