/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: DTOGenerator.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-persistence/src/main/java/org/nuiton/topia/generator/DTOGenerator.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */




/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1894 $
*
* Mise a jour: $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ANNOTATION;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.Transformer;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;

// do not remove me :)
import org.apache.commons.lang.StringUtils;

/**
 * DTO generator
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.DTOGenerator"
 * @deprecated since 2.3.0, prefer use the corresponding {@link Transformer} :
 * {@link DTOTransformer}.
 */
@Deprecated
public class DTOGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(DTOGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DTO.java";
    }

    public boolean isDTO(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO);
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
        String clazzName = clazz.getName();
output.write("package "+clazz.getPackageName()+";\n");
output.write("\n");
output.write("import org.apache.commons.lang.builder.ToStringBuilder;\n");
output.write("import java.beans.PropertyChangeListener;\n");
output.write("import java.util.List;\n");
output.write("import java.util.Collection;\n");
output.write("\n");
output.write("/**\n");
output.write(" * DTO implantation for "+StringUtils.capitalize(clazzName)+" entity.\n");
output.write(" */\n");
output.write("public class "+clazzName+"DTO");

/*
 * Définition de la super classe : il ne doit y avoir qu'une
 */        
        
        String extendClass = "";
        Iterator<ObjectModelClass> j = clazz.getSuperclasses().iterator();
        if (j.hasNext()) {
        	ObjectModelClassifier parent = j.next();
        	if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
        		extendClass += parent.getName() + "DTO";
        	} else {
        		extendClass += parent.getName();
        	}
        }

        if (extendClass.length() > 0) {
output.write(" extends "+extendClass+"");
        }
/*
 * Définition des interfaces
 */
output.write(" implements java.io.Serializable");
        String implInterface = "";
        for (Iterator<ObjectModelInterface> i=clazz.getInterfaces().iterator(); i.hasNext();) {
        	ObjectModelClassifier parentInterface = i.next();
        	if (parentInterface.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DTO)) {
        		implInterface += parentInterface.getName() + "DTO";
        	} else {
        		implInterface += parentInterface.getName();
        	}
        	
        	if (i.hasNext()) {
        		implInterface += ", ";
        	}
        }
        if (implInterface.length() > 0) {
output.write(", "+implInterface+" {\n");
output.write("\n");
output.write("");
        } else {
        	output.write(" {\n");
output.write("\n");
output.write("");
        }

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        // TODO Calculer un serialVersionUID si il n'y en a pas
        if (svUID != null) {
output.write("    public static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");
        }
/*
 * Définition des attributs
 */
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            
            if (!(attr.isNavigable()
                   || attr.hasAssociationClass())) {
                continue;
            }	
            
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("    /**\n");
output.write("     * "+attr.getDocumentation()+"\n");
output.write("     */\n");
output.write("");
            }
            String annotation = attr.getTagValue(TAG_ANNOTATION);
            if (annotation != null && annotation.length() > 0) {
output.write("    "+annotation+"\n");
output.write("");
            }
            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
                	if (isDTO(attrType)) {
                		attrType += "DTO";
                	}
output.write("    "+attrVisibility+" "+attrType+" "+attrName+";\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
output.write("    "+attrVisibility+" "+assocClassFQN+"DTO "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("");
                }
            } else {
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<";
                	} else {
                		nMultType = "Collection<";
                	}
                	nMultType += attrType;
                	if (isDTO(attrType)) {
                		nMultType += "DTO";
                	}
                	nMultType += ">";
output.write("    "+attrVisibility+" "+nMultType+" "+attrName+";\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<";
                	} else {
                		nMultType = "Collection<";
                	}
                	nMultType += assocClassFQN;
                	if (isDTO(attrType)) {
                		nMultType += "DTO";
                	}
                	nMultType += ">";
output.write("    "+attrVisibility+" "+nMultType+" "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("");
                }
            }
        } /* end for*/

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrName = attr.getName();
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                	if (isDTO(attrType)) {
                		attrType += "DTO";
                	}
output.write("    "+attrVisibility+" "+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+";\n");
output.write("");
                }
            }
        }
output.write("\n");
output.write("    protected java.beans.PropertyChangeSupport p;\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Default constructor of "+clazzName+"DTO.\n");
output.write("     */\n");
output.write("    public "+clazzName+"DTO() {\n");
output.write("        p = new java.beans.PropertyChangeSupport(this);\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Constructor of "+clazzName+"DTO with all parameters.\n");
output.write("     */\n");
output.write("    public "+clazzName+"DTO(");
        
        boolean une_fois = true;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            if (une_fois) {
                une_fois = false;
            } else {
output.write(", ");
            }

            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
        	if (isDTO(attrType)) {
        		attrTypeDTO += "DTO";
        	}
            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
output.write(""+attrTypeDTO+" "+attrName+"");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
output.write(""+assocClassFQN+"DTO "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"");
                }
            } else {
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
output.write(""+nMultType+" "+attrName+"");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
output.write(""+nMultType+" "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+"");
                }
            }


        } // end for
        
        output.write(" ) {\n");
output.write("        this();\n");
output.write("");


        for (ObjectModelAttribute attr : clazz.getAttributes()) {

            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            String attrName = attr.getName();

            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
output.write("        this."+attrName+" = "+attrName+";\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
output.write("	       this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("");
                }
            } else {
                if (!attr.hasAssociationClass()) {
output.write("	       this."+attrName+" = "+attrName+";\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
output.write("	       this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("");
                }
            }
        }
output.write("    }\n");
output.write("\n");
output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("        p.addPropertyChangeListener(listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
output.write("        p.addPropertyChangeListener(propertyName, listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void removePropertyChangeListener(PropertyChangeListener listener) {\n");
output.write("        p.removePropertyChangeListener(listener);\n");
output.write("    }\n");
output.write("\n");
output.write("    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
output.write("        p.removePropertyChangeListener(propertyName, listener);\n");
output.write("    }\n");
output.write("    \n");
output.write("");


        /*
         * Définition des getteurs et setteurs
         */
        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!attr.isNavigable()) {
                continue;
            }

            String attrName = attr.getName();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
            if (isDTO(attrType)) {
            	attrTypeDTO += "DTO";
            }

            if (!GeneratorUtil.isNMultiplicity(attr)) {
                if (!attr.hasAssociationClass()) {
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrTypeDTO+" value) {\n");
output.write("        "+attrTypeDTO+" oldValue = this."+attrName+";\n");
output.write("        this."+attrName+" = value;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValue, value);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+attrTypeDTO+" get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return "+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+"DTO association) {\n");
output.write("        "+assocClassFQN+"DTO oldAssocation = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = association;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldAssocation, assocation);\n");
output.write("    }\n");
output.write("\n");
output.write("    public "+assocClassFQN+"DTO get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return "+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
            } else { //NMultiplicity
                if (!attr.hasAssociationClass()) { //Méthodes remplacées par des accesseurs sur les classes d'assoc
                    
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+nMultType+" values) {\n");
output.write("        "+nMultType+" oldValues = this."+attrName+";\n");
output.write("        this."+attrName+" = values;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n");
output.write("    }\n");
output.write("\n");
output.write("");

                    //AddChild
output.write("    public "+attrTypeDTO+" addChild("+attrTypeDTO+" "+attrName+") {\n");
output.write(" 	this."+attrName+".add("+attrName+");\n");
output.write("");
                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
output.write(" 	"+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(this);\n");
output.write("");
                    }
output.write(" 	return "+attrName+";\n");
output.write("    }\n");
output.write("      \n");
output.write("");
                    //RemoveChild
output.write("    public void removeChild("+attrTypeDTO+" "+attrName+") {\n");
output.write("        this."+attrName+".remove("+attrName+");\n");
output.write("");
                    if (reverse != null && reverse.isNavigable()) {
                        String reverseAttrName = reverse.getName();
output.write(" 	"+attrName+".set"+StringUtils.capitalize(reverseAttrName)+"(null);\n");
output.write("");
                    }
output.write("    }\n");
output.write("      \n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+nMultType+" values) {\n");
output.write("        "+nMultType+" oldValues = this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("        this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+" = values;\n");
output.write("        p.firePropertyChange(\""+attrName+"\", oldValues, values);\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
                if (!attr.hasAssociationClass()) {
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + attrTypeDTO + ">";
                	} else {
                		nMultType = "Collection<" + attrTypeDTO + ">";
                	}
output.write("    public "+nMultType+" get"+StringUtils.capitalize(attrName)+"() {\n");
output.write("        return this."+attrName+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
                } else {
                    String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                	String nMultType;
                	if (attr.isOrdered()) {
                		nMultType = "List<" + assocClassFQN + "DTO>";
                	} else {
                		nMultType = "Collection<" + assocClassFQN + "DTO>";
                	}
                    if (log.isTraceEnabled()) {
                        log.trace("assocAttrName: " + assocAttrName);
                    }
output.write("    public "+nMultType+" get"+StringUtils.capitalize(assocAttrName)+"() {\n");
output.write("        return this."+GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)+";\n");
output.write("    }\n");
output.write("\n");
output.write("");
                }
            }
        }

output.write("\n");
output.write("    @Override\n");
output.write("    public String toString() {\n");
output.write("        String result = new ToStringBuilder(this).\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!(attr.isNavigable()
                    || attr.hasAssociationClass())) {
                continue;
            }

            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isDTO = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)); //THIMEL : STEREOTYPE ENTITY ???
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isDTO && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isDTO)) {
            	String attrName = attr.getName();
output.write("            append(\""+attrName+"\", this."+attrName+").\n");
output.write("");
            }
        }
output.write("         toString();   \n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+clazz.getName()+"DTO\n");
output.write("");
    }

} //DTOGenerator
