/**
 * *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package org.nuiton.topia.persistence.util;

import java.util.Map;

/**
 * A simple contract to load an object from another one.
 *
 * @param <E> type of bean to load
 * @author chemit
 */
public interface Loador<E> extends java.io.Serializable {

    /**
     * Obtain from an entity all data to bind to another one according the definition of the loador.
     * <p/>
     * This method is usefull when you can not directly used the {@link #load(Object, Object, boolean)} method.
     * <p/>
     * For example, when an entity has a immutable business key (says with an hibernate naturalId for example),
     * and that you want to create the data in a db, you must give all the properties at the create time so
     * this method allow you to do it).
     *
     * @param from the entity to bind
     * @return the map of properties to bind from the given entity.
     */
    Map<String, Object> obtainProperties(E from);

    @Deprecated
    Map<String, Object> obtainProgperties(E from);

    /**
     * Bind an entity to another.
     *
     * @param from the source entity
     * @param dst  the destination entity
     * @param tech a flag to bind or not the technical values of the entity (says TopiaId, TopiaVersion and TopiaCreateDate).
     */
    void load(E from, E dst, boolean tech);
}
