/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.topia.generator.TopiaGeneratorUtil;

public class DTOTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(DTOTransformer.class);

    public void transformFromClass(ObjectModelClass clazz) {
        if (!clazz.hasStereotype("dto")) {
            return;
        }
        String clazzName = clazz.getName();
        ObjectModelClass result = this.createClass(clazzName + "DTO", clazz.getPackageName());
        this.addImport((ObjectModelClassifier)result, ToStringBuilder.class);
        this.addImport((ObjectModelClassifier)result, PropertyChangeListener.class);
        this.setDocumentation((ObjectModelElement)result, "Implantation DTO pour l'entit\u00e9 " + StringUtils.capitalize((String)clazzName) + ".");
        String extendClass = "";
        Iterator i$ = clazz.getSuperclasses().iterator();
        if (i$.hasNext()) {
            ObjectModelClass parent = (ObjectModelClass)i$.next();
            extendClass = parent.getQualifiedName() + "DTO";
        }
        if (extendClass.length() > 0) {
            this.setSuperClass(result, extendClass);
        }
        this.addInterface((ObjectModelClassifier)result, Serializable.class);
        for (ObjectModelInterface parentInterface : clazz.getInterfaces()) {
            if (parentInterface.hasStereotype("dto")) {
                this.addInterface((ObjectModelClassifier)result, parentInterface.getName() + "DTO");
                continue;
            }
            this.addInterface((ObjectModelClassifier)result, parentInterface.getName());
        }
        this.addAttributes(result, clazz);
        this.addOperations(result, clazz);
    }

    protected void addAttributes(ObjectModelClass result, ObjectModelClass clazz) {
        String svUID = TopiaGeneratorUtil.findTagValue((String)"dto-serialVersionUID", (ObjectModelElement)clazz, (Model)this.model);
        if (StringUtils.isNotEmpty((String)svUID)) {
            this.addAttribute((ObjectModelClassifier)result, "serialVersionUID", Long.TYPE, svUID, new ObjectModelModifier[]{ObjectModelModifier.FINAL, ObjectModelModifier.PUBLIC, ObjectModelModifier.STATIC});
        }
        this.addAttribute((ObjectModelClassifier)result, "p", PropertyChangeSupport.class, null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED});
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String annotation;
            ObjectModelAttribute attr2;
            String assocAttrName;
            String attributeName;
            String attributeType;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable() && !attr.hasAssociationClass()) continue;
            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (!attr.hasAssociationClass()) {
                    if (this.isDTO(attrType)) {
                        attrType = attrType + "DTO";
                    }
                    attributeType = attrType;
                    attributeName = attrName;
                } else {
                    assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                    attributeType = attr.getAssociationClass().getQualifiedName();
                    attributeName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                }
            } else if (!attr.hasAssociationClass()) {
                String nMultType = attr.isOrdered() ? List.class.getName() + "<" : Collection.class.getName() + "<";
                nMultType = nMultType + attrType;
                if (this.isDTO(attrType)) {
                    nMultType = nMultType + "DTO";
                }
                attributeType = nMultType = nMultType + ">";
                attributeName = attrName;
            } else {
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                String nMultType = attr.isOrdered() ? List.class.getName() + "<" : Collection.class.getName() + "<";
                nMultType = nMultType + assocClassFQN;
                if (this.isDTO(attrType)) {
                    nMultType = nMultType + "DTO";
                }
                attributeType = nMultType = nMultType + ">";
                attributeName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
            }
            if ((attr2 = this.addAttribute((ObjectModelClassifier)result, attributeName, attributeType, null, new ObjectModelModifier[]{ObjectModelModifier.PROTECTED})) == null) continue;
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                this.setDocumentation((ObjectModelElement)attr2, attr.getDocumentation());
            }
            if (!StringUtils.isNotEmpty((String)(annotation = attr.getTagValue("annotation")))) continue;
            this.addAnnotation((ObjectModelClassifier)result, (ObjectModelElement)attr2, annotation);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                String attrName = attr.getName();
                String attrVisibility = attr.getVisibility();
                String attrType = attr.getType();
                if (this.isDTO(attrType)) {
                    attrType = attrType + "DTO";
                }
                this.addAttribute((ObjectModelClassifier)result, GeneratorUtil.toLowerCaseFirstLetter((String)attrName), attrType);
            }
        }
    }

    protected void addOperations(ObjectModelClass result, ObjectModelClass clazz) {
        ObjectModelOperation op = this.addOperation((ObjectModelClassifier)result, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.addPropertyChangeListener(listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "addPropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, String.class, "propertyName");
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.addPropertyChangeListener(propertyName, listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.removePropertyChangeListener(listener);\n    ");
        op = this.addOperation((ObjectModelClassifier)result, "removePropertyChangeListener", "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        this.addParameter(op, String.class, "propertyName");
        this.addParameter(op, PropertyChangeListener.class, "listener");
        this.setOperationBody(op, "\n        p.removePropertyChangeListener(propertyName, listener);\n    ");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            String nMultType;
            String nMultType2;
            String assocClassFQN;
            String assocAttrName;
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable()) continue;
            String attrName = attr.getName();
            String attrType = attr.getType();
            String attrTypeDTO = attr.getType();
            if (this.isDTO(attrType)) {
                attrTypeDTO = attrTypeDTO + "DTO";
            }
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                if (!attr.hasAssociationClass()) {
                    op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.addParameter(op, attrTypeDTO, "value");
                    this.setOperationBody(op, "\n        " + attrTypeDTO + " oldValue = this." + attrName + ";\n" + "        this." + attrName + " = value;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValue, value);\n" + "    ");
                    op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), attrTypeDTO, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                    this.setOperationBody(op, "\n        return " + attrName + ";\n" + "    ");
                    continue;
                }
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName));
                }
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, assocClassFQN + "DTO", "association");
                this.setOperationBody(op, "\n        " + assocClassFQN + "DTO oldAssocation = this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = association;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldAssocation, assocation);\n" + "    ");
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), assocClassFQN + "DTO", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.setOperationBody(op, "\n        return " + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "    ");
                continue;
            }
            if (!attr.hasAssociationClass()) {
                String reverseAttrName;
                nMultType2 = attr.isOrdered() ? List.class.getName() + "<" + attrTypeDTO + ">" : Collection.class.getName() + "<" + attrTypeDTO + ">";
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)attrName), "void", new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, nMultType2, "values");
                this.setOperationBody(op, "\n        " + nMultType2 + " oldValues = this." + attrName + ";\n" + "        this." + attrName + " = values;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValues, values);\n" + "    ");
                op = this.addOperation((ObjectModelClassifier)result, "addChild" + StringUtils.capitalize((String)attrName), attrTypeDTO, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
                this.addParameter(op, attrTypeDTO, attrName);
                StringBuilder buffercode = new StringBuilder();
                buffercode.append("\n        this." + attrName + ".add(" + attrName + ");\n" + "    ");
                if (reverse != null && reverse.isNavigable()) {
                    reverseAttrName = reverse.getName();
                    buffercode.append("        " + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(this);\n" + "    ");
                }
                buffercode.append("        return " + attrName + ";\n" + "    ");
                this.setOperationBody(op, buffercode.toString());
                op = this.addOperation((ObjectModelClassifier)result, "removeChild", "void", new ObjectModelModifier[0]);
                this.addParameter(op, attrTypeDTO, attrName);
                buffercode = new StringBuilder();
                buffercode.append("\n        this." + attrName + ".remove(" + attrName + ");\n" + "    ");
                if (reverse != null && reverse.isNavigable()) {
                    reverseAttrName = reverse.getName();
                    buffercode.append(" \t" + attrName + ".set" + StringUtils.capitalize((String)reverseAttrName) + "(null);\n" + "    ");
                }
                this.setOperationBody(op, buffercode.toString());
            } else {
                assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                assocClassFQN = attr.getAssociationClass().getQualifiedName();
                nMultType = attr.isOrdered() ? List.class.getName() + "<" + assocClassFQN + "DTO>" : Collection.class.getName() + "<" + assocClassFQN + "DTO>";
                if (log.isTraceEnabled()) {
                    log.trace((Object)("assocAttrName: " + assocAttrName));
                }
                op = this.addOperation((ObjectModelClassifier)result, "set" + StringUtils.capitalize((String)assocAttrName), "void", new ObjectModelModifier[0]);
                this.addParameter(op, nMultType, "values");
                this.setOperationBody(op, "\n        " + nMultType + " oldValues = this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "        this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + " = values;\n" + "        p.firePropertyChange(\"" + attrName + "\", oldValues, values);\n" + "    ");
            }
            if (!attr.hasAssociationClass()) {
                nMultType2 = attr.isOrdered() ? List.class.getName() + "<" + attrTypeDTO + ">" : Collection.class.getName() + "<" + attrTypeDTO + ">";
                op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)attrName), nMultType2, new ObjectModelModifier[0]);
                this.setOperationBody(op, "\n        return this." + attrName + ";\n" + "    ");
                continue;
            }
            assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            assocClassFQN = attr.getAssociationClass().getQualifiedName();
            nMultType = attr.isOrdered() ? List.class.getName() + "<" + assocClassFQN + "DTO>" : Collection.class.getName() + "<" + assocClassFQN + "DTO>";
            if (log.isTraceEnabled()) {
                log.trace((Object)("assocAttrName: " + assocAttrName));
            }
            op = this.addOperation((ObjectModelClassifier)result, "get" + StringUtils.capitalize((String)assocAttrName), nMultType, new ObjectModelModifier[0]);
            this.setOperationBody(op, "\n        return this." + GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName) + ";\n" + "    ");
        }
        op = this.addOperation((ObjectModelClassifier)result, "toString", String.class, new ObjectModelModifier[]{ObjectModelModifier.PUBLIC});
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n        String result = new ToStringBuilder(this).\n");
        for (ObjectModelAttribute o : clazz.getAttributes()) {
            ObjectModelAttribute attr = o;
            if (!attr.isNavigable() && !attr.hasAssociationClass()) continue;
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isDTO = attrEntity != null && attrEntity.hasStereotype("entity");
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((!isDTO || reverse != null && reverse.isNavigable() || attr.hasAssociationClass()) && isDTO) continue;
            String attrName = attr.getName();
            buffer.append("            append(\"" + attrName + "\", this." + attrName + ").\n" + "");
        }
        buffer.append("         toString();\n        return result;\n    ");
        this.setOperationBody(op, buffer.toString());
    }

    public boolean isDTO(String type) {
        ObjectModelClassifier clazz = ((ObjectModel)this.model).getClassifier(type);
        return clazz != null && clazz.hasStereotype("dto");
    }
}

