package org.nuiton.topiatest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topiatest.deletetest.Party2Impl;


public abstract class PersonneAbstract extends Party2Impl implements Personne {

    public String name;
    public Collection<String> otherNames;
    public Address address;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Personne.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Personne.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "otherNames", Collection.class, String.class, otherNames);
        visitor.visit(this, "address", Address.class, address);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
}

    /**
     * addOtherNames :
     * @param otherNames 
     */

    public void addOtherNames(String otherNames) {    
        fireOnPreWrite("otherNames", null, otherNames);
        if (this.otherNames == null) {
            this.otherNames = new ArrayList<String>();
        }
        this.otherNames.add(otherNames);
        fireOnPostWrite("otherNames", this.otherNames.size(), null, otherNames);
}

    /**
     * addAllOtherNames :
     * @param values 
     */

    public void addAllOtherNames(Collection<String> values) {
        if (values == null) {
            return;
        }
        for (String item : values) {
            addOtherNames(item);
        }
}

    /**
     * setOtherNames :
     * @param values 
     */

    public void setOtherNames(Collection<String> values) {
        Collection<String> _oldValue = otherNames;
        fireOnPreWrite("otherNames", _oldValue, values);
        otherNames = values;
        fireOnPostWrite("otherNames", _oldValue, values);
}

    /**
     * removeOtherNames :
     * @param value 
     */

    public void removeOtherNames(String value) {
        fireOnPreWrite("otherNames", value, null);
        if ((this.otherNames == null) || (!this.otherNames.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite("otherNames", this.otherNames.size()+1, value, null);
}

    /**
     * clearOtherNames :
     */

    public void clearOtherNames() {
        if (this.otherNames == null) {
            return;
        }
        Collection<String> _oldValue = new ArrayList<String>(this.otherNames);
        fireOnPreWrite("otherNames", _oldValue, this.otherNames);
        this.otherNames.clear();
        fireOnPostWrite("otherNames", _oldValue, this.otherNames);
}

    /**
     * getOtherNames :
     * @return Collection<String> 
     */

    public Collection<String> getOtherNames() {
        return otherNames;
}

    /**
     * sizeOtherNames :
     * @return int 
     */

    public int sizeOtherNames() {
        if (otherNames == null) {
            return 0;
        }
        return otherNames.size();
}

    /**
     * isOtherNamesEmpty :
     * @return boolean 
     */

    public boolean isOtherNamesEmpty() {
        int size = sizeOtherNames();
        return size == 0;
}

    /**
     * setAddress :
     * @param value 
     */

    public void setAddress(Address value) {
        Address _oldValue = this.address;
        fireOnPreWrite("address", _oldValue, value);
        this.address = value;
        fireOnPostWrite("address", _oldValue, value);
}

    /**
     * getAddress :
     * @return Address 
     */

    public Address getAddress() {
        fireOnPreRead("address", address);
        Address result = this.address;
        fireOnPostRead("address", address);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
            append("otherNames", this.otherNames).
            append("address", this.address).
         toString();
        return result;
}

static {
    
    org.nuiton.i18n.I18n.n_("topia.test.common.personne");
    org.nuiton.i18n.I18n.n_("topia.test.common.name");
    org.nuiton.i18n.I18n.n_("topia.test.common.otherNames");
    org.nuiton.i18n.I18n.n_("topia.test.common.address");
    }

} //PersonneAbstract
