/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/




/* *
* EntityGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isBooleanType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isNumericType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isTextType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isPrimitiveType;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.isDateType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

// do not remove me :)
import org.apache.commons.lang.StringUtils;

/**
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link EntityInterfaceTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityInterfaceGenerator" 
 */
@Deprecated
public class EntityInterfaceGenerator extends ObjectModelGenerator {

    /** Logger for this class */
    private static final Log log = LogFactory.getLog(EntityInterfaceGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        return interfacez.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    //TC-20091214 : never used : always generate from a <<entity>> class
//    @Override
//    public void generateFromInterface(Writer output, ObjectModelInterface interfacez) throws IOException {
//        if (!interfacez.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
//            return;
//        }
//
//        if (log.isDebugEnabled()) {
//            log.debug("Generating interface for : " + interfacez.getName());
//        }
//
//        generateInterfaceHeaderFromClassifier(output, interfacez);
//
//        generateInterfaceOperations(output, interfacez);
//
///{} //<%=interfacez.getName()%>
//}*/
//    }

    private String getStringRepresentation(List<String> strings) {
        StringBuffer result = new StringBuffer();
        String doubleQuote = "\"";
        String comma = ",";
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            result.append(doubleQuote);
            result.append(it.next());
            result.append(doubleQuote);
            if (it.hasNext()) {
                result.append(comma);
            }
        }
        return result.toString();
    }

    private void generateSearchFields(Writer output, ObjectModelClass clazz) throws IOException {
        List<String> txtFields = new ArrayList<String>();
        List<String> numFields = new ArrayList<String>();
        List<String> boolFields = new ArrayList<String>();
        List<String> dateFields = new ArrayList<String>();
        List<ObjectModelAttribute> allAttrs = new ArrayList<ObjectModelAttribute>();
        allAttrs.addAll(clazz.getAttributes());
        allAttrs.addAll(clazz.getAllOtherAttributes());
        boolean needAnnotation = false;
        for (ObjectModelAttribute attr : allAttrs) {
            String name = GeneratorUtil.toLowerCaseFirstLetter(attr.getName());
            if (isTextType(attr)) {
                txtFields.add(name);
                needAnnotation = true;
            } else if (isNumericType(attr)) {
                numFields.add(name);
                needAnnotation = true;
            } else if (isBooleanType(attr)) {
                boolFields.add(name);
                needAnnotation = true;
            } else if (isDateType(attr)) {
                dateFields.add(name);
                needAnnotation = true;
            }
        }
output.write("@SearchFields (");
        if (needAnnotation) {
            StringBuilder buffer = new StringBuilder();
            if (!txtFields.isEmpty()) {
                buffer.append("\n  txtFields={").append(getStringRepresentation(txtFields)).append("}");
                if (!numFields.isEmpty() || !boolFields.isEmpty() || !dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!numFields.isEmpty()) {
                buffer.append("\n  numFields={").append(getStringRepresentation(numFields)).append("}");
                if (!boolFields.isEmpty() || !dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!boolFields.isEmpty()) {
                buffer.append("\n  boolFields={").append(getStringRepresentation(boolFields)).append("}");
                if (!dateFields.isEmpty()) {
                    buffer.append(",");
                }
            }
            if (!dateFields.isEmpty()) {
                buffer.append("\n  dateFields={").append(getStringRepresentation(dateFields)).append("}");
            }            
output.write(""+buffer.toString()+"\n");
output.write("");
        }
output.write(")        \n");
output.write("");
    }

    private void generateInterfaceHeaderFromClassifier(Writer output, ObjectModelClassifier classifier) throws IOException {
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
output.write(""+copyright+"\n");
output.write("");
        }
output.write("package "+classifier.getPackageName()+";\n");
output.write("\n");
output.write("import org.nuiton.topia.persistence.SearchFields;\n");
output.write("import org.nuiton.topia.persistence.TopiaEntity;\n");
output.write("\n");
output.write("");
        if (TopiaGeneratorUtil.hasDocumentation(classifier)) {
        	String documentation = classifier.getDocumentation();
output.write("\n");
output.write("/**\n");
output.write(" * "+documentation+"\n");
output.write(" */\n");
output.write("");
        }
        //
        if (classifier instanceof ObjectModelClass) {
            generateSearchFields(output, (ObjectModelClass) classifier);
        }
        String classifierName = classifier.getName();
output.write("public interface "+classifierName+" extends ");
        String extendClass = "";
        for (ObjectModelClassifier parent : classifier.getInterfaces()) {
            extendClass += parent.getQualifiedName();
            extendClass += ", ";
        }
        if (classifier instanceof ObjectModelClass) {
            ObjectModelClass clazz = (ObjectModelClass) classifier;
            for (ObjectModelClassifier parent : clazz.getSuperclasses()) {
                if (parent.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
                    extendClass += parent.getQualifiedName();
                }
                extendClass += ", ";
            }
        }

output.write(""+extendClass+"TopiaEntity {\n");
output.write("\n");
output.write("");
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String clazzName = clazz.getName();
        generateInterfaceHeaderFromClassifier(output, clazz);

        generateStaticColumnNames(output, clazz);

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!attr.isNavigable()
                    && !hasUnidirectionalRelationOnAbstractType(reverse, model)) {
                continue;
            }

            String attrName = attr.getName();
            String attrType = attr.getType();
            if (!attr.hasAssociationClass()) {
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+" La valeur de l'attribut "+attrName+" à positionner.\n");
output.write("     */\n");
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+");\n");
output.write("\n");
output.write("");
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @return La valeur de l'attribut "+attrName+".\n");
output.write("     */\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"();\n");
output.write("\n");
output.write("");
                } else {
                    String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+" L'instance de "+attrName+" à ajouter.\n");
output.write("     */\n");
output.write("    public void add"+StringUtils.capitalize(attrName)+"("+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+" Les instances de "+attrName+" à ajouter.\n");
output.write("     */\n");
output.write("    public void addAll"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+"> "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+" La Collection de "+attrName+" à positionner.\n");
output.write("     */\n");
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+collectionInterface+"<"+attrType+"> "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+" L'instance de "+attrName+" à retirer.\n");
output.write("     */\n");
output.write("    public void remove"+StringUtils.capitalize(attrName)+"("+attrType+" "+GeneratorUtil.toLowerCaseFirstLetter(attrName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * Vide la Collection de "+attrName+".\n");
output.write("     */\n");
output.write("    public void clear"+StringUtils.capitalize(attrName)+"();\n");
output.write("\n");
output.write("");

output.write("    /**\n");
output.write("");
                    if (TopiaGeneratorUtil.hasDocumentation(attr)) {
output.write("     * "+attrName+" : "+attr.getDocumentation()+"\n");
output.write("");
                    }
output.write("     * @return La Liste de "+attrName+".\n");
output.write("     */\n");
output.write("    public "+collectionInterface+"<"+attrType+"> get"+StringUtils.capitalize(attrName)+"();\n");
output.write("\n");
output.write("");
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
output.write("\n");
output.write("    /**\n");
output.write("     * Recupère l'attribut "+attrName+" à partir de son topiaId.\n");
output.write("     *\n");
output.write("     * @param topiaId le topia id de l'entité recherchée\n");
output.write("     *\n");
output.write("     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.\n");
output.write("     */\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"ByTopiaId(String topiaId);\n");
output.write(" ");
                    }
output.write("\n");
output.write("    /**\n");
output.write("     * @return Le nombre d'éléments de la collection "+attrName+".\n");
output.write("     */\n");
output.write("    public int size"+StringUtils.capitalize(attrName)+"();\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return <code>true</code> si la collection "+attrName+" est vide.\n");
output.write("     */\n");
output.write("    public boolean is"+StringUtils.capitalize(attrName)+"Empty();\n");
output.write("\n");
output.write("");

                }
            } else {
            	String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            	String assocClassName = attr.getAssociationClass().getName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
output.write("    /**\n");
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" La valeur de l'attribut "+assocClassName+" à positionner.\n");
output.write("     */\n");
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return La valeur de l'attribut "+assocClassName+".\n");
output.write("     */\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("\n");
output.write("");
                } else {
                    String collectionInterface = TopiaGeneratorUtil.getNMultiplicityInterfaceType(attr);
output.write("    /**\n");
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" L'instance de "+assocClassName+" à ajouter.\n");
output.write("     */\n");
output.write("    public void add"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" Les instances de "+assocClassName+" à ajouter.\n");
output.write("     */\n");
output.write("    public void addAll"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+"> "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" La Collection de "+assocClassName+" à positionner.\n");
output.write("     */\n");
output.write("    public void set"+StringUtils.capitalize(assocAttrName)+"("+collectionInterface+"<"+assocClassFQN+"> "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @param "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+" L'instance de "+assocClassName+" à retirer.\n");
output.write("     */\n");
output.write("    public void remove"+StringUtils.capitalize(assocAttrName)+"("+assocClassFQN+" "+GeneratorUtil.toLowerCaseFirstLetter(assocClassName)+");\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Vide la Collection de "+assocClassName+".\n");
output.write("     */\n");
output.write("    public void clear"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return La liste des attributs "+assocClassName+".\n");
output.write("     */\n");
output.write("    public "+collectionInterface+"<"+assocClassFQN+"> get"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("");
                    if (!isPrimitiveType(attr) && !isDateType(attr)) {
output.write("\n");
output.write("    /**\n");
output.write("     * Recupère l'attribut "+attrName+" à partir de son topiaId.\n");
output.write("     *\n");
output.write("     * @param topiaId le topia id de l'attribut recherchée\n");
output.write("     * \n");
output.write("     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.\n");
output.write("     */\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"ByTopiaId(String topiaId);\n");
output.write("");
                    }
output.write("\n");
output.write("    /**\n");
output.write("     * @return L'attribut "+assocClassName+" associé à la valeur <code>value</code> de l'attribut "+attrName+".\n");
output.write("     */\n");
output.write("    public "+assocClassFQN+" get"+StringUtils.capitalize(assocAttrName)+"("+attrType+" value);\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return Le nombre d'éléments de la collection "+attrName+".\n");
output.write("     */\n");
output.write("    public int size"+StringUtils.capitalize(assocAttrName)+"();\n");
output.write("  \n");
output.write("    /**\n");
output.write("     * @return <code>true</code> si la collection "+assocAttrName+" est vide.\n");
output.write("     */\n");
output.write("    public boolean is"+StringUtils.capitalize(assocAttrName)+"Empty();\n");
output.write("");

                }
            }
        }

        //Méthodes d'accès aux attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String type = attr.getType();
                    String name = attr.getName();
                    generateAssociationAccessors(output, name, type);
                    if (attr.getReverseAttribute() == null) {
                        type = ((ObjectModelClassifier) attr.getDeclaringElement()).getQualifiedName();
                        name = attr.getDeclaringElement().getName();
                        generateAssociationAccessors(output, name, type);
                    }
                }
            }
        }

        generateInterfaceOperations(output, clazz);

output.write("} //"+clazzName+"\n");
output.write("");
    }

    private void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            // Pas de génération des signatures de méthodes pour celles à intégrer au DAO de l'entité
            if (!op.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_DAO)) {
                String opName = op.getName();
output.write("    /**\n");
output.write("");
                if (TopiaGeneratorUtil.hasDocumentation(op)) {
                    String opDocumentation = op.getDocumentation();
output.write("     * "+opName+" : "+opDocumentation+"\n");
output.write("");
                }
                Collection<ObjectModelParameter> params = op.getParameters();
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramDocumentation = param.getDocumentation();
output.write("     * @param "+paramName+" "+paramDocumentation+"\n");
output.write(" ");
                }
                String opVisibility = op.getVisibility();
                String opType = op.getReturnType();
output.write("     */\n");
output.write("    "+opVisibility+" "+opType+" "+opName+"(");
                String comma = "";
                for (ObjectModelParameter param : params) {
                    String paramName = param.getName();
                    String paramType = param.getType();
output.write(""+comma+""+paramType+" "+paramName+"");
                    comma = ", ";
                }
output.write(")");
                Set<String> exceptions = op.getExceptions();
                comma = " throws ";
                for (String exception : exceptions) {
output.write(""+comma+""+exception+"");
                    comma = ", ";
                }
output.write(";\n");
output.write("\n");
output.write("");
            }
        }
    }

    private void generateAssociationAccessors(Writer output, String attrName, String attrType) throws IOException {
output.write("    /**\n");
output.write("     * @param value La valeur de l'attribut "+attrName+" à positionner.\n");
output.write("     */\n");
output.write("    public void set"+StringUtils.capitalize(attrName)+"("+attrType+" value);\n");
output.write("\n");
output.write("    /**\n");
output.write("     * @return La valeur de l'attribut "+attrName+".\n");
output.write("     */\n");
output.write("    public "+attrType+" get"+StringUtils.capitalize(attrName)+"();\n");
output.write("\n");
output.write("");
    }

    private void generateStaticColumnNames(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            String attrName;
            if (!attr.hasAssociationClass()) {
                attrName = attr.getName();
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter(assocAttrName);
            }
            String attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
            //String attrColName = attrName.toUpperCase();
output.write("    public static final String "+attrColName+" = \""+attrName+"\";\n");
output.write("\n");
output.write("");
        }

        //Déclaration des noms des champs des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass) clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrName = attr.getName();
                    String attrColName = TopiaGeneratorUtil.convertVariableNameToConstantName(attrName);
                    //String attrColName = attrName.toUpperCase();
output.write("    public static final String "+attrColName+" = \""+attrName+"\";\n");
output.write("\n");
output.write("");
                }
            }
        }
    }

} //EntityGenerator
