package org.nuiton.topia.it.legacy.topiatest.deletetest;

/*-
 * #%L
 * ToPIA :: IT
 * %%
 * Copyright (C) 2004 - 2024 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;

public abstract class Telephone2Abstract extends Contact2Impl implements Telephone2 {

    /**
     * Nom de l'attribut en BD : prefix
     */
    protected String prefix;

    /**
     * Nom de l'attribut en BD : country
     */
    protected String country;

    private static final long serialVersionUID = 3616498692672139876L;

    static {
    
        I18n.n("topia.test.common.telephone2");
        I18n.n("topia.test.common.prefix");
        I18n.n("topia.test.common.country");
    }

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    @Override
    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        super.accept0(visitor);
        visitor.visit(this, PROPERTY_PREFIX, String.class, prefix);
        visitor.visit(this, PROPERTY_COUNTRY, String.class, country);
    }

    @Override
    public void setPrefix(String prefix) {
        String oldValue = this.prefix;
        fireOnPreWrite(PROPERTY_PREFIX, oldValue, prefix);
        this.prefix = prefix;
        fireOnPostWrite(PROPERTY_PREFIX, oldValue, prefix);
    }

    @Override
    public String getPrefix() {
        fireOnPreRead(PROPERTY_PREFIX, prefix);
        String result = this.prefix;
        fireOnPostRead(PROPERTY_PREFIX, prefix);
        return result;
    }

    @Override
    public void setCountry(String country) {
        String oldValue = this.country;
        fireOnPreWrite(PROPERTY_COUNTRY, oldValue, country);
        this.country = country;
        fireOnPostWrite(PROPERTY_COUNTRY, oldValue, country);
    }

    @Override
    public String getCountry() {
        fireOnPreRead(PROPERTY_COUNTRY, country);
        String result = this.country;
        fireOnPostRead(PROPERTY_COUNTRY, country);
        return result;
    }

} //Telephone2Abstract
