/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.it;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopiaSchemaHelper {
    private static final Log log = LogFactory.getLog(TopiaSchemaHelper.class);

    protected static void closeQuietly(Connection connection) {
        block3: {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Unable to close: " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
    }

    protected static void closeQuietly(Statement statement) {
        block3: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Unable to close: " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(Map<String, String> config, String schemaName) throws Exception {
        Connection connection = null;
        CallableStatement callableStatement = null;
        try {
            connection = DriverManager.getConnection(config.get("hibernate.connection.url"), config.get("hibernate.connection.username"), config.get("hibernate.connection.password"));
            callableStatement = connection.prepareCall("create schema " + schemaName);
            callableStatement.execute();
        }
        catch (Throwable throwable) {
            TopiaSchemaHelper.closeQuietly(callableStatement);
            TopiaSchemaHelper.closeQuietly(connection);
            throw throwable;
        }
        TopiaSchemaHelper.closeQuietly(callableStatement);
        TopiaSchemaHelper.closeQuietly(connection);
    }

    public static void createMappingDataBaseSchemas(Map<String, String> config) throws Exception {
        TopiaSchemaHelper.createSchema(config, "A");
        TopiaSchemaHelper.createSchema(config, "B");
    }
}

