package org.nuiton.topia.it.legacy.topiatest;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.it.legacy.TopiaTestEntityEnum;
import org.nuiton.topia.persistence.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;

@Generated(value = "org.nuiton.topia.templates.EntityDaoTransformer", date = "Tue Dec 03 19:40:57 CET 2013")
public abstract class GeneratedTypeTopiaDao<E extends Type> extends AbstractTopiaDao<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>) Type.class;
    }

    @Override
    public TopiaTestEntityEnum getTopiaEntityEnum() {
        return TopiaTestEntityEnum.Type;
    }

    @Override
    public void delete(E entity) {
        if ( ! entity.isPersisted()) {
            throw new IllegalArgumentException("entity " + entity  + " is not persisted, you can't delete it");
        }

        {
            ProductTopiaDao dao = topiaDaoSupplier
                    .getDao(Product.class, ProductTopiaDao.class);
            List<Product> list = dao
                    .forProperties(Product.PROPERTY_TYPE, entity)
                    .findAll();
            for (Product item : list) {

                // sletellier : Set null only if target is concerned by deletion
                if (entity.equals(item.getType())) {
                    item.setType(null);
                }
            
            }
        }

        super.delete(entity);
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameIn(Iterable<String> v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forIn(Type.PROPERTY_NAME, (Iterable) v);
        return result;
    }

    public TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> forNameEquals(String v) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep<E> result = forEquals(Type.PROPERTY_NAME, v);
        return result;
    }

    @Deprecated
    public E findByName(String v) {
        return forNameEquals(v).findAnyOrNull();
    }

    @Deprecated
    public List<E> findAllByName(String v) {
        return forNameEquals(v).findAll();
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) {
        List<?> result = new LinkedList();
        List tmp;

        if (type == Product.class) {
            ProductTopiaDao dao =
                topiaDaoSupplier.getDao(Product.class, ProductTopiaDao.class);
            tmp = dao.forTypeEquals(entity).findAll();
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Product.class, entity);
        if (!list.isEmpty()) {
            result.put(Product.class, list);
        }

        return result;
    }

} //GeneratedTypeTopiaDao<E extends Type>
