/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.nuiton.processor.filters.Filter;

public class ProcessorReader
extends BufferedReader {
    protected BufferedReader input;
    protected Filter filter;
    protected String lineSeparator;

    protected ProcessorReader() {
        super(new StringReader(""));
    }

    public ProcessorReader(BufferedReader input, Filter filter) {
        this();
        this.setInput(input);
        this.filter = filter;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void setInput(BufferedReader input) {
        this.input = input;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public String readLine() throws IOException {
        String line;
        if (this.input.ready() && (line = this.input.readLine()) != null) {
            if (!(this.input instanceof ProcessorReader)) {
                line = line + this.lineSeparator;
            }
            return this.filter.parse(line);
        }
        if (this.filter.hasCachedData()) {
            return this.filter.flush();
        }
        return null;
    }

    @Override
    public boolean ready() {
        try {
            boolean ready = this.input.ready();
            if (ready) {
                return true;
            }
            return this.filter.hasCachedData();
        }
        catch (IOException eee) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

