/* *##% nuiton-processor - lib
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
 * GeneratorTemplatesFilterIn.java
 *
 * Created: 14 janv. 2004
 *
 * @author Benjamin Poussin <poussin@codelutin.com>
 * Copyright Code Lutin
 * @version $Revision: 255 $
 *
 * Mise a jour: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $
 * par : $Author: tchemit $
 */

package org.nuiton.processor.filters;

/**
 * Le tag *) n'est substitué que s'il est a l'extérieur du tag <%=...%>ou
 * <%...%>
 */
public class GeneratorTemplatesFilterIn extends DefaultFilter { // GeneratorTemplatesFilterIn

    GeneratorTemplatesFilter parent = null;

    public GeneratorTemplatesFilterIn(GeneratorTemplatesFilter parent) {
        this.parent = parent;
    }

    /**
     * méthode appelée lorsqu'on a la chaîne entière entre le header et le
     * footer.
     *
     * @param ch
     *            la chaîne trouvé
     * @return ce qu'il faut écrire dans le fichier de sortie
     */
    @Override
    protected String performInFilter(String ch) {
        if (ch.startsWith("=")) {
            return "\"+" + ch.substring(1) + "+\"";
        }
        return "\");" + ch + parent.getWriteString() + "(\"";
    }

    /**
     * Converti les fin de commentaire *) en fin normal de commentraire
     * @param ch la chaine a convertir
     * @return la chaine convertie
     */
    protected String convertEndComment(String ch) {
        String result = ch.replaceAll("\\*\\)", "*/");
        return result;
    }

    /**
     * methode appele lorsqu'on a la chaine entiere a l'exterieur du
     * header/footer
     *
     * @param ch
     *            la chaine trouve
     * @return ce qu'il faut ecrire dans le fichier de sortie
     */
    @Override
    protected String performOutFilter(String ch) {
        String result = convertEndComment(ch).replaceAll("\"", "\\\\\"")
                .replaceAll("(\r\n|\n|\r)",
                        "\\\\n\");\n" + parent.getWriteString() + "(\"");
        // it's important that \r\n is first in regexp.

        return result;
    }

    @Override
    protected String getHeader() {
        return "<%";
    }

    @Override
    protected String getFooter() {
        return "%>";
    }

} // GeneratorTemplatesFilterIn

