/* *##% nuiton-processor - lib
 * Copyright (C) 2002 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

/* *
* LogsProcessor.java
*
* Created: Wed Jan 14 2004
*
* @author  <poussin@codelutin.com>
* Copyright Code Lutin
* @version $Revision: 255 $
*
* Mise a jour: $Date: 2009-08-16 09:50:25 +0200 (dim., 16 août 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.processor;

import org.nuiton.processor.filters.*;
import java.io.*;

/*
* This class is a processor for source logs
*/
public class LogsProcessor extends Processor {

    /** Type of actions */
    protected static class Action {}
    /** Do nothing */
    public final static Action NoAction = new Action();

    /** Active logs in output. This is the default action */
    public final static Action Logs = new Action();
    /** Remove logs in output */
    public final static Action NoLogsCode = new Action();

    public LogsProcessor (Action action) {
        if (action == NoAction) {
            // No action is the default filter in Processor
        } else if (action == NoLogsCode) {
            setInputFilter(new RemoveLogsCodeFilter());
        } else {
            // Go for logs
            setInputFilter(new ActiveLogsCodeFilter());
        }
    }

    public static void main(String [] args) throws Exception {
        LogsProcessor processor;
        if(args.length < 2) {
            System.out.println("Give source and destination file, then action");
            System.out.println("Action may be remove or active (default is no action)");
            System.exit(0);
        } else if (args.length > 2) {
            if (args[2].equals("remove")) {
                processor = new LogsProcessor(NoLogsCode);
                System.out.println("Removing logs code");
            } else if (args[2].equals("active")) {
                processor = new LogsProcessor(Logs);
                System.out.println("Setting logs active");
            } else {
                processor = new LogsProcessor(NoAction);
                System.out.println("No action taken");
            }
            try {
                processor.process(new FileReader(args[0]),
                new FileWriter(args[1]));
            } catch (IOException eee) {
                java.util.logging.Logger.getLogger("org.nuiton.processor.LogsProcessor.").severe("Error during log processing: "+eee);
            }
        }
    }
}
