/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.xwork2.field;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NuitonFieldValidatorSupport
extends FieldValidatorSupport {
    private static final Log log = LogFactory.getLog(NuitonFieldValidatorSupport.class);
    protected String skip = "false";

    public void setSkip(String skip) {
        this.skip = skip;
    }

    protected abstract void validateWhenNotSkip(Object var1) throws ValidationException;

    public void validate(Object object) throws ValidationException {
        boolean mustSkip = this.evaluateSkipParameter(object);
        if (mustSkip) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip the validation from " + (Object)((Object)this) + ", due to skip parameter evaluated to true"));
            }
            return;
        }
        this.validateWhenNotSkip(object);
    }

    protected boolean evaluateSkipParameter(Object object) throws ValidationException {
        this.skip = this.skip.trim();
        if ("false".equals(this.skip)) {
            return false;
        }
        if ("true".equals(this.skip)) {
            return true;
        }
        try {
            Boolean answer = Boolean.FALSE;
            Object obj = this.getFieldValue(this.skip, object);
            if (obj != null && obj instanceof Boolean) {
                answer = (Boolean)obj;
            }
            return answer;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidationException("Can not evaluate boolean expression [" + this.skip + "] for reason " + e.getMessage());
        }
    }

    public Object getFieldValue(String name, Object object) throws ValidationException {
        return super.getFieldValue(name, object);
    }
}

