/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.version;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class VersionComparator
implements Comparator<Version>,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int compare(Version o1, Version o2) {
        int o1NbComponants = o1.getComponantCount();
        int o2NbComponants = o2.getComponantCount();
        int minComponantSize = Math.min(o1NbComponants, o2NbComponants);
        int maxComponantSize = Math.max(o1NbComponants, o2NbComponants);
        int result = 0;
        for (int i = 0; result == 0 && i < minComponantSize; ++i) {
            Version.VersionComponant o1Componant = o1.getComponant(i);
            Version.VersionComponant o2Componant = o2.getComponant(i);
            result = Objects.equals(o1Componant.getClass(), o2Componant.getClass()) ? o1Componant.compareTo(o2Componant) : (o1Componant instanceof Version.NumberVersionComponant ? 1 : -1);
        }
        if (result == 0 && minComponantSize != maxComponantSize) {
            Version.StringVersionComponant stringVersionComponant;
            Version.VersionComponant componant;
            result = o2NbComponants == minComponantSize ? ((componant = o1.getComponant(minComponantSize)) instanceof Version.StringVersionComponant ? ((stringVersionComponant = (Version.StringVersionComponant)componant).isPreRelease() ? -1 : 1) : 1) : ((componant = o2.getComponant(minComponantSize)) instanceof Version.StringVersionComponant ? ((stringVersionComponant = (Version.StringVersionComponant)componant).isPreRelease() ? 1 : -1) : -1);
        }
        if (result == 0 && ObjectUtils.notEqual((Object)o1.isSnapshot(), (Object)o2.isSnapshot())) {
            result = o2.isSnapshot() ? 1 : -1;
        }
        return result;
    }

    public static void main(String ... args) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (String arg : args) {
            Version version = Versions.valueOf(arg);
            versions.add(version);
        }
        versions.sort(Collections.reverseOrder(new VersionComparator()));
        String join = Joiner.on((char)' ').join(versions);
        System.out.println(join);
    }
}

