/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.GZUtil;

public class FileUtil {
    private static final Log log = LogFactory.getLog(FileUtil.class);
    public static String ENCODING = "ISO-8859-1";
    @Deprecated
    protected static File currentDirectory = new File(".");

    @Deprecated
    public static void setCurrentDirectory(File dir) {
        currentDirectory = dir;
    }

    @Deprecated
    public static File getCurrentDirectory() {
        return currentDirectory;
    }

    @Deprecated
    public static File getFile(String ... patternOrDescriptionFilters) {
        File result = FileUtil.getFile(null, patternOrDescriptionFilters);
        return result;
    }

    @Deprecated
    public static File getFile(javax.swing.filechooser.FileFilter ... filters) {
        File result = FileUtil.getFile(null, filters);
        return result;
    }

    @Deprecated
    public static File getFile(Component parent, String ... patternOrDescriptionFilters) {
        File result = FileUtil.getFile("Ok", "Ok", parent, patternOrDescriptionFilters);
        return result;
    }

    @Deprecated
    public static File getFile(String title, String approvalText, Component parent, String ... patternOrDescriptionFilters) {
        if (patternOrDescriptionFilters.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments must be (pattern, description) couple");
        }
        javax.swing.filechooser.FileFilter[] filters = new javax.swing.filechooser.FileFilter[patternOrDescriptionFilters.length / 2];
        for (int i = 0; i < filters.length; ++i) {
            String pattern = patternOrDescriptionFilters[i * 2];
            String description = patternOrDescriptionFilters[i * 2 + 1];
            filters[i] = new PatternChooserFilter(pattern, description);
        }
        File result = FileUtil.getFile(title, approvalText, parent, filters);
        return result;
    }

    @Deprecated
    public static File getFile(Component parent, javax.swing.filechooser.FileFilter ... filters) {
        File result = FileUtil.getFile("Ok", "Ok", parent, filters);
        return result;
    }

    @Deprecated
    public static File getFile(String title, String approvalText, Component parent, javax.swing.filechooser.FileFilter ... filters) {
        try {
            File theFile;
            JFileChooser chooser = new JFileChooser(currentDirectory);
            chooser.setDialogType(2);
            if (filters.length > 0) {
                if (filters.length == 1) {
                    chooser.setFileFilter(filters[0]);
                } else {
                    for (javax.swing.filechooser.FileFilter filter : filters) {
                        chooser.addChoosableFileFilter(filter);
                    }
                }
            }
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(title);
            int returnVal = chooser.showDialog(parent, approvalText);
            if (returnVal == 0 && (theFile = chooser.getSelectedFile()) != null) {
                currentDirectory = theFile;
                return theFile.getAbsoluteFile();
            }
        }
        catch (Exception eee) {
            log.warn((Object)"Erreur:", (Throwable)eee);
        }
        return null;
    }

    @Deprecated
    public static String getDirectory() {
        return FileUtil.getDirectory(null, "Ok", "Ok");
    }

    @Deprecated
    public static String getDirectory(String title, String approvalText) {
        String result = FileUtil.getDirectory(null, title, approvalText);
        return result;
    }

    @Deprecated
    public static String getDirectory(Component parent, String title, String approvalText) {
        block5: {
            try {
                JFileChooser chooser = new JFileChooser(currentDirectory);
                chooser.setDialogType(2);
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle(title);
                int returnVal = chooser.showDialog(parent, approvalText);
                if (returnVal == 0) {
                    File theFile = chooser.getSelectedFile();
                    if (theFile != null) {
                        currentDirectory = theFile;
                        if (theFile.isDirectory()) {
                            return theFile.getAbsolutePath();
                        }
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception eee) {
                log.warn((Object)"Erreur:", (Throwable)eee);
            }
        }
        return null;
    }

    public static File byteToFile(byte[] bytes) throws IOException {
        File file = File.createTempFile("FileUtil-byteToFile", ".tmp");
        FileUtil.byteToFile(bytes, file);
        return file;
    }

    @Deprecated
    public static File byteToFile(byte[] bytes, File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ((OutputStream)out).write(bytes);
        }
        finally {
            ((OutputStream)out).close();
        }
        return file;
    }

    public static BufferedReader getReader(File file) throws IOException {
        return FileUtil.getReader(file, ENCODING);
    }

    public static BufferedReader getReader(File file, String encoding) throws IOException {
        FileInputStream inf = new FileInputStream(file);
        InputStreamReader in = new InputStreamReader((InputStream)inf, encoding);
        BufferedReader result = new BufferedReader(in);
        return result;
    }

    public static BufferedWriter getWriter(File file) throws IOException {
        return FileUtil.getWriter(file, ENCODING);
    }

    public static BufferedWriter getWriter(File file, String encoding) throws IOException {
        FileOutputStream outf = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outf, encoding);
        BufferedWriter result = new BufferedWriter(out);
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix, File tmpdir) throws IOException {
        if (tmpdir == null) {
            tmpdir = new File(System.getProperty("java.io.tmpdir"));
        }
        File result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        while (result.exists()) {
            result = new File(tmpdir, prefix + System.currentTimeMillis() + suffix);
        }
        if (!result.mkdirs()) {
            throw new IOException("Can't create temporary directory: " + result);
        }
        return result;
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.createTempDirectory(prefix, suffix, null);
    }

    @Deprecated
    public static void writeString(File file, String content, String encoding) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        BufferedWriter out = FileUtil.getWriter(file, encoding);
        out.write(content);
        out.close();
    }

    public static File getTempFile(String content) throws IOException {
        return FileUtil.getTempFile(content, "");
    }

    public static File getTempFile(String content, String fileSuffix) throws IOException {
        File result = File.createTempFile("tmp-" + FileUtil.class.getName(), fileSuffix);
        result.deleteOnExit();
        FileUtils.write((File)result, (CharSequence)content);
        return result;
    }

    public static String basename(File file, String ... suffixes) {
        String result = FileUtil.basename(file.getName(), suffixes);
        return result;
    }

    public static String basename(String name, String ... suffixes) {
        String result = name;
        for (String suffixe : suffixes) {
            if (!result.endsWith(suffixe)) continue;
            result = result.substring(0, result.length() - suffixe.length());
            break;
        }
        return result;
    }

    public static String extension(File file, String ... extchars) {
        String name = file.getName();
        String result = FileUtil.extension(name, extchars);
        return result;
    }

    public static String extension(String name, String ... extchars) {
        String result = "";
        if (extchars.length == 0) {
            extchars = new String[]{"."};
        }
        for (String extchar : extchars) {
            int pos = name.lastIndexOf(extchar);
            if (pos == -1) continue;
            result = name.substring(pos + extchar.length());
            break;
        }
        return result;
    }

    public static File changeExtension(File file, String newExtension, String ... extchars) throws IOException {
        String name = file.getName();
        String newName = FileUtil.changeExtension(name, newExtension, extchars);
        File newFile = new File(file.getParentFile(), newName);
        return newFile;
    }

    public static String changeExtension(String name, String newExtension, String ... extchars) throws IOException {
        String extension = FileUtil.extension(name, extchars);
        if (extension == null) {
            throw new IOException("Could not find extension for name " + name + " within " + Arrays.toString(extchars));
        }
        String nameWithoutExtension = name.substring(0, name.length() - extension.length());
        String newName = nameWithoutExtension + newExtension;
        return newName;
    }

    public static File getRelativeFile(File inputDirectory, File outputDirectory, File file) {
        String inputPath = inputDirectory.getAbsolutePath();
        String s = file.getAbsolutePath();
        int index = s.indexOf(inputPath);
        if (index == -1) {
            throw new IllegalArgumentException("File " + file + " is not in " + inputDirectory);
        }
        String relativePath = s.substring(inputPath.length());
        File result = new File(outputDirectory, relativePath);
        return result;
    }

    public static List<File> getSubDirectories(File directory) {
        class DirectoryFilter
        implements FileFilter {
            DirectoryFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        }
        return FileUtil.getFilteredElements(directory, new DirectoryFilter(), true);
    }

    public static List<File> getFiles(File directory) {
        class NormalFileFilter
        implements FileFilter {
            NormalFileFilter() {
            }

            @Override
            public boolean accept(File f) {
                return f.isFile();
            }
        }
        return FileUtil.getFilteredElements(directory, new NormalFileFilter(), true);
    }

    public static List<File> find(File directory, final String pattern, boolean recursively) {
        String root = directory.getAbsolutePath();
        final int rootLength = root.length();
        return FileUtil.getFilteredElements(directory, new FileFilter(){

            @Override
            public boolean accept(File f) {
                String longFilename = f.getAbsolutePath();
                String filename = longFilename.substring(rootLength + 1);
                return filename.matches(pattern);
            }
        }, recursively);
    }

    public static List<File> getFilteredElements(File directory, FileFilter ff, boolean recursively) {
        ArrayList<File> result = new ArrayList<File>();
        LinkedList<File> todo = new LinkedList<File>();
        if (directory.isDirectory()) {
            todo.addAll(Arrays.asList(directory.listFiles()));
        }
        while (todo.size() > 0) {
            File[] childs;
            File file = (File)todo.removeFirst();
            if (recursively && file.isDirectory() && (childs = file.listFiles()) != null) {
                todo.addAll(Arrays.asList(childs));
            }
            if (ff != null && !ff.accept(file)) continue;
            result.add(file);
        }
        return result;
    }

    public static boolean walkAfter(File f, FileAction fileAction) {
        boolean result = fileAction.doAction(f);
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkAfter(aList, fileAction);
            }
        }
        return result;
    }

    public static boolean walkBefore(File f, FileAction fileAction) {
        boolean result = true;
        if (f.isDirectory()) {
            File[] list;
            for (File aList : list = f.listFiles()) {
                result = result && FileUtil.walkBefore(aList, fileAction);
            }
        }
        return result && fileAction.doAction(f);
    }

    public static void copyRecursively(File srcDir, File destDir, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, null, null, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, String renameFrom, String renameTo, String ... includePatterns) throws IOException {
        FileUtil.copyAndRenameRecursively(srcDir, destDir, true, renameFrom, renameTo, false, includePatterns);
    }

    public static void copyAndRenameRecursively(File srcDir, File destDir, boolean includeSrcDir, String renameFrom, String renameTo, boolean exclude, String ... includePatterns) throws IOException {
        String rootSrc = includeSrcDir ? srcDir.getParent() : srcDir.getPath();
        List<File> files = FileUtil.getFilteredElements(srcDir, null, true);
        log.debug((Object)("copyRecursively: " + files));
        for (File file : files) {
            boolean doCopy = FileUtil.copyRecursivelyAccept(file, includePatterns);
            if (!(exclude ^ doCopy)) continue;
            String path = file.getPath().substring(rootSrc.length());
            if (renameFrom != null && renameTo != null) {
                String tmp = path.replaceAll(renameFrom, renameTo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("rename " + path + " \u2192 " + tmp));
                }
                path = tmp;
            }
            File destFile = new File(destDir, path);
            if (file.isDirectory()) {
                log.debug((Object)("create directory: " + destFile));
                FileUtil.createDirectoryIfNecessary(destFile);
                continue;
            }
            log.debug((Object)("copy " + path + " to " + destFile));
            FileUtils.copyFile((File)file, (File)destFile);
        }
    }

    public static ByteArrayOutputStream readBytesFrom(InputStream inputStream, int defaultBufferSize) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(defaultBufferSize);
        byte[] buffer = new byte[defaultBufferSize];
        int readBytes = inputStream.read(buffer);
        while (readBytes > 0) {
            outputStream.write(buffer, 0, readBytes);
            readBytes = inputStream.read(buffer);
        }
        return outputStream;
    }

    private static boolean copyRecursivelyAccept(File file, String[] includePatterns) {
        String pattern;
        boolean result = includePatterns.length == 0;
        String filename = file.getAbsolutePath();
        String[] stringArray = includePatterns;
        int n = stringArray.length;
        for (int i = 0; i < n && !(result = filename.matches(pattern = stringArray[i])); ++i) {
        }
        return result;
    }

    protected static List<CharSequence> grep(String regex, CharBuffer cb) {
        ArrayList<String> linesList = null;
        Pattern pattern = Pattern.compile(regex);
        Pattern linePattern = Pattern.compile(".*\r?\n");
        Matcher lm = linePattern.matcher(cb);
        Matcher pm = null;
        while (lm.find()) {
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                if (linesList == null) {
                    linesList = new ArrayList<String>();
                }
                linesList.add(cs);
            }
            if (lm.end() != cb.limit()) continue;
            break;
        }
        return linesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CharSequence> grep(String searchRegex, File f, String encoding) throws IOException {
        List<CharSequence> lines = null;
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            lines = FileUtil.grep(searchRegex, cb);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return lines;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, File rootDirectory, String fileRegex, String encoding) throws IOException {
        HashMap<File, List<CharSequence>> results = new HashMap<File, List<CharSequence>>();
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            List<CharSequence> lines = FileUtil.grep(searchRegex, file, encoding);
            if (lines == null) continue;
            results.put(file, lines);
        }
        return results;
    }

    public static Map<File, List<CharSequence>> grep(String searchRegex, String fileRegex, String encoding) throws IOException {
        Map<File, List<CharSequence>> results = FileUtil.grep(searchRegex, new File("."), fileRegex, encoding);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sed(String searchRegex, String replace, File file, String encoding) throws IOException {
        Pattern pattern = Pattern.compile(searchRegex);
        String outString = null;
        FileInputStream fis = new FileInputStream(file);
        try {
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            Charset charset = Charset.forName(encoding);
            CharsetDecoder decoder = charset.newDecoder();
            CharBuffer cb = decoder.decode(bb);
            Matcher matcher = pattern.matcher(cb);
            outString = matcher.replaceAll(replace);
        }
        finally {
            fis.close();
        }
        if (outString != null) {
            PrintStream ps = new PrintStream(new FileOutputStream(file));
            try {
                ps.print(outString);
            }
            finally {
                ps.close();
            }
        }
    }

    public static void sed(String searchRegex, String replace, File rootDirectory, String fileRegex, String encoding) throws IOException {
        List<File> files = FileUtil.find(rootDirectory, fileRegex, true);
        for (File file : files) {
            FileUtil.sed(searchRegex, replace, file, encoding);
        }
    }

    public static void sed(String searchRegex, String replace, String fileRegex, String encoding) throws IOException {
        FileUtil.sed(searchRegex, replace, new File("."), fileRegex, encoding);
    }

    public static boolean createDirectoryIfNecessary(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return false;
    }

    public static File getFileFromPaths(File rootDirectory, String ... paths) {
        File result = rootDirectory;
        for (String path : paths) {
            result = new File(result, path);
        }
        return result;
    }

    public static File getFileFromFQN(File rootDirectory, String fqn) {
        String[] paths = fqn.split("\\.");
        File result = FileUtil.getFileFromPaths(rootDirectory, paths);
        return result;
    }

    public static File getTestSpecificDirectory(Class<?> testClassName, String methodName, String classifier, long timestamp) {
        File tempDirFile = SystemUtils.getJavaIoTmpDir();
        String dataBasePath = testClassName.getName() + File.separator + methodName;
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            dataBasePath = dataBasePath + classifier;
        }
        dataBasePath = dataBasePath + (95L + timestamp);
        File databaseFile = new File(tempDirFile, dataBasePath);
        return databaseFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGzipFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            boolean gzip = GZUtil.isGzipStream(in);
            ((InputStream)in).close();
            boolean bl = gzip;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static interface FileAction {
        public boolean doAction(File var1);
    }

    @Deprecated
    public static class PatternChooserFilter
    extends javax.swing.filechooser.FileFilter {
        protected String pattern;
        protected String description;

        public PatternChooserFilter(String pattern, String description) {
            this.pattern = pattern;
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getAbsolutePath().matches(this.pattern);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

