/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProject;
import org.nuiton.jredmine.plugin.DryRunAware;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="publish-news", requiresOnline=true, requiresProject=true)
public class PublishNewsMojo
extends AbstractRedmineMojoWithProject
implements DryRunAware {
    @Parameter(property="redmine.anonymous", defaultValue="false")
    protected boolean anonymous;
    @Parameter(property="redmine.newsContentFile", required=true)
    protected File newsContentFile;
    @Parameter(property="redmine.newsSummary")
    protected String newsSummary;
    @Parameter(property="redmine.newsTitle", required=true)
    protected String newsTitle;
    @Parameter(property="redmine.skipPublishNews", defaultValue="false")
    protected boolean skipPublishNews;
    @Parameter(property="redmine.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;
    @Parameter(property="redmine.runOnlyOnRoot", defaultValue="true")
    protected boolean runOnlyOnRoot;
    protected boolean runOnceDone;

    public PublishNewsMojo() {
        super(true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public String getSkipProperty() {
        return "skipPublishNews";
    }

    @Override
    public boolean isGoalSkip() {
        return this.skipPublishNews;
    }

    @Override
    public boolean checkRunOnceDone() {
        StringBuilder buffer = new StringBuilder("publish-news");
        buffer.append("##").append(this.newsTitle);
        buffer.append("##").append(this.newsSummary);
        buffer.append("##").append(this.newsContentFile);
        String key = buffer.toString();
        return !this.needInvoke(this.runOnce, false, key);
    }

    @Override
    public boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    public boolean isRunOnlyOnRoot() {
        return this.runOnlyOnRoot;
    }

    @Override
    public boolean isRunOnceDone() {
        return this.runOnceDone;
    }

    @Override
    protected void init() throws Exception {
        if (this.isGoalSkip()) {
            return;
        }
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        if (this.newsSummary == null || this.newsSummary.trim().isEmpty()) {
            this.newsSummary = this.project.getUrl();
        }
        if (!this.newsContentFile.exists()) {
            throw new MojoExecutionException("could not find the template " + this.newsContentFile);
        }
        this.newsTitle = this.newsTitle.trim();
        if (this.newsTitle.length() > 60) {
            this.getLog().warn((CharSequence)("News title can not be longer than 60 caracters, but was " + this.newsTitle.length()));
            this.newsTitle = this.newsTitle.substring(0, 59);
            this.getLog().warn((CharSequence)("will use the restricted title : " + this.newsTitle));
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        News news = new News();
        news.setAuthorId(this.releaseUser.getId());
        news.setProjectId(this.releaseProject.getId());
        news.setTitle(this.newsTitle);
        news.setSummary(this.newsSummary);
        String newsContent = PluginHelper.readAsString((File)this.newsContentFile, (String)this.encoding);
        news.setDescription(newsContent);
        if (this.dryRun) {
            this.getLog().info((CharSequence)("news title   : " + news.getTitle()));
            this.getLog().info((CharSequence)("news summary : " + news.getSummary()));
            this.getLog().info((CharSequence)("news content :\n" + newsContent));
            return;
        }
        this.getLog().info((CharSequence)("publish news " + news.getTitle()));
        if (this.verbose) {
            this.getLog().info((CharSequence)("redmine announcement :\n" + newsContent));
        }
        news = this.service.addNews(this.projectId, news);
        if (this.verbose) {
            this.getLog().info((CharSequence)("done. news id : " + news.getId()));
        }
    }
}

