/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.helper.plugin.CollectFilesMojo;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProjectAndVersion;
import org.nuiton.jredmine.plugin.DryRunAware;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="publish-attachments", requiresOnline=true, requiresProject=true)
public class PublishAttachmentsMojo
extends AbstractRedmineMojoWithProjectAndVersion
implements DryRunAware {
    @Parameter(property="redmine.anonymous", defaultValue="false")
    protected boolean anonymous;
    @Parameter(property="redmine.filesFromProperties")
    protected File filesFromProperties;
    @Parameter(property="redmine.files")
    protected File[] files;
    @Parameter(property="redmine.skipCollectReleaseAttachments", defaultValue="false")
    protected boolean skipPublishAttachments;
    @Parameter(property="redmine.dryRun", defaultValue="false")
    protected boolean dryRun;
    @Parameter(property="redmine.runOnce", defaultValue="true")
    protected boolean runOnce;
    protected List<File> allFiles;

    public PublishAttachmentsMojo() {
        super(true, true);
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Override
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    protected boolean isGoalSkip() {
        return this.skipPublishAttachments;
    }

    @Override
    protected boolean isRunOnce() {
        return this.runOnce;
    }

    @Override
    protected boolean checkRunOnceDone() {
        return this.isRunOnce() && !this.isExecutionRoot();
    }

    @Override
    protected void init() throws Exception {
        this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        if (this.filesFromProperties != null && !this.filesFromProperties.exists()) {
            this.getLog().warn((CharSequence)("could not find the properties file " + this.filesFromProperties));
            this.getLog().warn((CharSequence)"will not use this source");
            this.filesFromProperties = null;
        }
        if (this.filesFromProperties != null && this.files != null && this.files.length > 0) {
            throw new MojoExecutionException("can not use both sources files and filesFromProperties");
        }
        this.allFiles = this.filesFromProperties != null ? this.getFilesToDeploy() : Arrays.asList(this.files);
        if (this.allFiles == null || this.allFiles.isEmpty()) {
            return;
        }
        this.runOnceDone = false;
        if (this.isRunOnce()) {
            this.runOnceDone = this.checkRunOnceDone();
            if (this.runOnceDone) {
                return;
            }
        }
        super.init();
    }

    @Override
    protected boolean checkSkip() {
        if (this.allFiles == null || this.allFiles.isEmpty()) {
            this.getLog().warn((CharSequence)"No attachment to publish, will skip the goal.");
            return false;
        }
        boolean b = super.checkSkip();
        return b;
    }

    @Override
    protected void doAction() throws Exception {
        if (this.dryRun) {
            this.getLog().info((CharSequence)"\n  dryRun flag is on, no data will be send!\n");
        }
        String basedir = this.project.getBasedir().getAbsolutePath();
        int basedirLength = basedir.length() + 1;
        for (File f : this.allFiles) {
            if (!f.exists()) {
                this.getLog().warn((CharSequence)("can not upload a non existing file " + f));
                continue;
            }
            if (f.getAbsolutePath().startsWith(basedir)) {
                this.getLog().info((CharSequence)("upload " + f.getAbsolutePath().substring(basedirLength)));
            } else {
                this.getLog().info((CharSequence)("upload " + f.getAbsolutePath()));
            }
            if (this.dryRun) continue;
            long t0 = System.nanoTime();
            Attachment a = new Attachment();
            a.setFilename(f.getName());
            a.setAuthorId(this.releaseUser.getId());
            a.setContainerId(this.releaseVersion.getId());
            a.setToUpload(f);
            Attachment result = this.service.addAttachment(this.projectId, this.releaseVersion.getName(), a);
            long t1 = System.nanoTime();
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("done in  " + PluginHelper.convertTime((long)(t1 - t0)) + ". attachment id : " + result.getId() + ", size : " + PluginHelper.convertMemory((long)result.getFilesize())));
        }
    }

    protected List<File> getFilesToDeploy() throws MojoExecutionException {
        List incoming;
        try {
            incoming = new CollectFilesMojo().getFiles(this.filesFromProperties);
            this.getLog().info((CharSequence)("Loaded " + this.filesFromProperties));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("could not load file " + this.filesFromProperties, (Exception)ex);
        }
        Collections.sort(incoming, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return incoming;
    }
}

