/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.rest;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.util.IOUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.io.rest.RestException;
import org.nuiton.io.rest.RestRequest;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class RedmineRestClientTest {
    static RestClientConfiguration configuration;
    RedmineRestClient client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpClass() throws Exception {
        configuration = TestHelper.getTestConfiguration();
        RedmineRestClient client = new RedmineRestClient(configuration);
        try {
            client.open();
        }
        catch (Exception e) {
            System.out.println("could not connect to server " + configuration.getRestUrl() + ", will skip test " + RedmineRestClientTest.class.getName());
        }
        finally {
            Assume.assumeTrue((boolean)client.isOpen());
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.client = new RedmineRestClient(configuration);
        this.client.open();
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void isOpen() throws Exception {
        Assert.assertTrue((boolean)this.client.isOpen());
    }

    @Test
    public void isClose() throws Exception {
        Assert.assertTrue((boolean)this.client.isOpen());
        this.client.close();
        Assert.assertFalse((boolean)this.client.isOpen());
    }

    @Test
    public void getDatas() throws Exception {
        String toString = this.doRequest(Project.class, "list", new Object[0]);
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(IssueStatus.class, "list", new Object[0]);
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(IssuePriority.class, "list", new Object[0]);
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Project.class, "detail", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(IssueCategory.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Version.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(User.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Tracker.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(News.class, "list", "one");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Version.class, "detail", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Issue.class, "list", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
        toString = this.doRequest(Attachment.class, "list", "one", "1.0.0");
        if (configuration.isVerbose()) {
            System.out.println(toString);
        }
    }

    protected String doRequest(Class<?> type, String action, Object ... params) throws IOException, RestException {
        String requestId = type.getName() + action;
        RestRequest request = this.client.getRequest(requestId, params);
        InputStream askData = this.client.askData(request);
        String toString = IOUtil.toString((InputStream)askData);
        return toString;
    }
}

