/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.io.rest.RestClient;
import org.nuiton.io.rest.RestClientConfiguration;
import org.nuiton.jredmine.DefaultRedmineService;
import org.nuiton.jredmine.RedmineService;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.TestHelper;
import org.nuiton.jredmine.model.Attachment;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.rest.RedmineRestClient;

public class DefaultRedmineServiceTest {
    static RedmineRestClient client;
    RedmineService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpClass() throws Exception {
        RestClientConfiguration configuration = TestHelper.getTestConfiguration();
        client = new RedmineRestClient(configuration);
        try {
            client.open();
        }
        catch (Exception e) {
            try {
                System.out.println("can not connect to server " + configuration.getRestUrl() + ", will skip test " + DefaultRedmineServiceTest.class.getName());
            }
            catch (Throwable throwable) {
                Assume.assumeTrue((client != null && client.isOpen() ? 1 : 0) != 0);
                throw throwable;
            }
            Assume.assumeTrue((client != null && client.isOpen() ? 1 : 0) != 0);
        }
        Assume.assumeTrue((client != null && client.isOpen() ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (client != null) {
            client.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.service = new DefaultRedmineService();
        ((RedmineServiceImplementor)this.service).init((RestClient)client);
    }

    @After
    public void tearDown() throws Exception {
        this.service = null;
    }

    @Test
    public void isInit() throws Exception {
        Assert.assertFalse((boolean)new DefaultRedmineService().isInit());
    }

    @Test
    public void getProjects() throws Exception {
        Project[] projects = this.service.getProjects();
    }

    @Test
    public void getIssuePriorities() throws Exception {
        IssuePriority[] suePriorities = this.service.getIssuePriorities();
    }

    @Test
    public void getIssueStatuses() throws Exception {
        IssueStatus[] sueStatuses = this.service.getIssueStatuses();
    }

    @Test
    public void getProject() throws Exception {
        Project project = this.service.getProject("one");
    }

    @Test
    public void getIssueCategories() throws Exception {
        IssueCategory[] sueCategories = this.service.getIssueCategories("one");
    }

    @Test
    public void getTrackers() throws Exception {
        Tracker[] trackers = this.service.getTrackers("one");
    }

    @Test
    public void getNews() throws Exception {
        News[] news = this.service.getNews("one");
    }

    @Test
    public void getUsers() throws Exception {
        User[] users = this.service.getUsers("one");
    }

    @Test
    public void getVersions() throws Exception {
        Version[] versions = this.service.getVersions("one");
    }

    @Test
    public void getVersion() throws Exception {
        Version version = this.service.getVersion("one", "1.0.0");
    }

    @Test
    public void getIssues() throws Exception {
        Issue[] sues = this.service.getIssues("one", "1.0.0");
    }

    @Test
    public void getAttachments() throws Exception {
        Attachment[] attachments = this.service.getAttachments("one", "1.0.0");
    }

    @Test
    public void addVersion() throws Exception {
    }

    @Test
    public void addAttachment() throws Exception {
    }

    @Test
    public void addNews() throws Exception {
    }

    @Test
    public void updateVersion() throws Exception {
    }

    @Test
    public void nextVersion() throws Exception {
    }
}

