/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerConfiguration;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXEngine;
import jaxx.compiler.beans.BeanInfoUtil;
import jaxx.compiler.decorators.HelpRootCompiledObjectDecorator;
import jaxx.compiler.tags.TagManager;
import jaxx.runtime.JAXXContext;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.MirroredFileUpdater;
import org.nuiton.jaxx.plugin.AbstractJaxxMojo;

public class GenerateMojo
extends AbstractJaxxMojo
implements CompilerConfiguration {
    private static final String[] INCLUDES = new String[]{"**\\/*.jaxx"};
    protected File src;
    protected File outJava;
    protected String[] includes;
    protected String[] excludes;
    protected String compilerFQN;
    protected String validatorFQN;
    protected String jaxxContextFQN;
    protected String defaultErrorUIFQN;
    protected String defaultDecoratorFQN;
    protected boolean addSourcesToClassPath;
    protected boolean addResourcesToClassPath;
    protected boolean addCompileClassPath;
    protected boolean addProjectClassPath;
    protected boolean force;
    protected boolean testPhase;
    protected boolean i18nable;
    protected boolean optimize;
    protected boolean addLogger;
    protected boolean resetAfterCompile;
    protected String[] beanInfoSearchPath;
    protected String extraImportList;
    protected boolean useUIManagerForIcon;
    protected boolean profile;
    protected boolean generateHelp;
    protected String helpBrokerFQN;
    protected String[] files;
    protected MirroredFileUpdater updater;
    private Class<?> defaultErrorUIClass;
    private Class<?> validatorClass;
    private Class<? extends CompiledObjectDecorator> defaultDecoratorClass;
    private Class<? extends JAXXContext> jaxxContextClass;
    private Class<? extends JAXXCompiler> compilerClass;
    private String[] extraImports;
    private boolean nofiles;
    protected ClassLoader cl;
    private JAXXEngine engine;

    public boolean init() throws Exception {
        if (this.generateHelp && this.getHelpIdsStore() == null) {
            throw new MojoFailureException("you must set the 'helpIdStore' property.");
        }
        this.fixCompileSourceRoots();
        if (this.includes == null || this.includes.length == 0) {
            this.includes = INCLUDES;
        }
        this.updater = FileUpdaterHelper.newJaxxFileUpdater((File)this.src, (File)this.outJava);
        HashMap result = new HashMap();
        this.getFilesToTreateForRoots(this.includes, this.excludes, Arrays.asList(this.src.getAbsolutePath()), result, this.force ? null : this.updater);
        this.files = (String[])result.get(this.src);
        boolean bl = this.nofiles = this.files == null || this.files.length == 0;
        if (this.nofiles) {
            return true;
        }
        this.cl = this.initClassLoader(this.project, this.src, this.addSourcesToClassPath, this.testPhase, this.addResourcesToClassPath, this.addCompileClassPath, this.addProjectClassPath);
        Thread.currentThread().setContextClassLoader(this.cl);
        this.compilerClass = Class.forName(this.compilerFQN, false, this.cl);
        this.defaultDecoratorClass = Class.forName(this.defaultDecoratorFQN, false, this.cl);
        this.jaxxContextClass = Class.forName(this.jaxxContextFQN, false, this.cl);
        if (!JAXXContext.class.isAssignableFrom(this.jaxxContextClass)) {
            throw new MojoExecutionException("jaxxContextFQN must be an implementation of " + JAXXContext.class + " but was : " + this.jaxxContextClass);
        }
        this.validatorClass = Class.forName(this.validatorFQN, false, this.cl);
        if (this.defaultErrorUIFQN != null && !this.defaultErrorUIFQN.trim().isEmpty()) {
            this.defaultErrorUIClass = Class.forName(this.defaultErrorUIFQN, false, this.cl);
        }
        if (this.beanInfoSearchPath != null && this.beanInfoSearchPath.length > 0) {
            BeanInfoUtil.addJaxxBeanInfoPath((String[])this.beanInfoSearchPath);
        }
        if (!this.getTargetDirectory().exists()) {
            this.getTargetDirectory().mkdirs();
        }
        if (this.extraImportList != null && !this.extraImportList.isEmpty()) {
            Object[] imports = this.extraImportList.split(",");
            int i = 0;
            for (String string : imports) {
                imports[i++] = string.trim();
            }
            if (this.verbose) {
                this.getLog().info((CharSequence)("extra imports " + Arrays.toString(imports)));
            }
            this.extraImports = imports;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)this.toString());
            this.getLog().info((CharSequence)("includes : " + Arrays.toString(this.includes)));
            for (String file : this.files) {
                this.getLog().info((CharSequence)("will parse " + file));
            }
        }
        return true;
    }

    public void doAction() throws MojoExecutionException {
        if (this.nofiles) {
            this.getLog().info((CharSequence)"No files to treate.");
            return;
        }
        this.getLog().info((CharSequence)("Detects " + this.files.length + " modified jaxx file(s). "));
        try {
            TagManager.reset((boolean)this.verbose);
            this.engine = JAXXEngine.newLaunchor((File)this.src, (String[])this.files, (CompilerConfiguration)this);
            int nbFiles = this.engine.run();
            this.report(this.engine);
            if (nbFiles == -1) {
                throw new MojoExecutionException("Aborting due to errors reported by jaxxc");
            }
            this.getLog().info((CharSequence)("Generated " + nbFiles + " file(s). "));
            if (this.generateHelp) {
                this.generateHelp();
            }
        }
        catch (MojoExecutionException e) {
            this.getLog().error((Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Throwable e2 = e;
            while (e2.getCause() != null) {
                e2 = e.getCause();
            }
            this.getLog().error(e2);
            throw new MojoExecutionException(e2.getMessage(), e2);
        }
    }

    @Override
    public File getTargetDirectory() {
        return this.outJava;
    }

    @Override
    public void setTargetDirectory(File targetDirectory) {
        this.outJava = targetDirectory;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public boolean isI18nable() {
        return this.i18nable;
    }

    public boolean isUseUIManagerForIcon() {
        return this.useUIManagerForIcon;
    }

    public boolean isAddLogger() {
        return this.addLogger;
    }

    public Class<? extends JAXXContext> getJaxxContextClass() {
        return this.jaxxContextClass;
    }

    public String[] getExtraImports() {
        return this.extraImports;
    }

    public boolean isResetAfterCompile() {
        return this.resetAfterCompile;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public Class<?> getDefaultErrorUI() {
        return this.defaultErrorUIClass;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public Class<? extends JAXXCompiler> getCompilerClass() {
        return this.compilerClass;
    }

    public Class<? extends CompiledObjectDecorator> getDefaultDecoratorClass() {
        return this.defaultDecoratorClass;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isGenerateHelp() {
        return this.generateHelp;
    }

    public String getHelpBrokerFQN() {
        return this.helpBrokerFQN;
    }

    public Class<?> getValidatorClass() {
        return this.validatorClass;
    }

    public JAXXEngine getEngine() {
        return this.engine;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    protected void fixCompileSourceRoots() {
        if (this.project == null) {
            return;
        }
        if (this.testPhase) {
            this.addTestCompileSourceRoots(this.getTargetDirectory());
        } else {
            this.addCompileSourceRoots(this.getTargetDirectory());
        }
    }

    protected void generateHelp() throws IOException {
        Set helpIds = HelpRootCompiledObjectDecorator.getHelpIds();
        if (helpIds.isEmpty()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"no helpIds detected.");
            }
            return;
        }
        File idsStore = this.getHelpIdsStore();
        if (!idsStore.getParentFile().exists()) {
            idsStore.getParentFile().mkdirs();
        }
        StringBuilder buffer = new StringBuilder();
        for (String helpId : helpIds) {
            buffer.append(this.removeQuote(helpId)).append('\n');
        }
        this.writeFile(idsStore, buffer.toString(), this.encoding);
        this.getLog().info((CharSequence)("helpIdStore generated in " + idsStore));
        helpIds.clear();
    }

    protected String removeQuote(String txt) {
        if (txt.startsWith("\"")) {
            txt = txt.substring(1);
        }
        if (txt.endsWith("\"")) {
            txt = txt.substring(0, txt.length() - 1);
        }
        return txt;
    }

    protected void report(JAXXEngine engine) {
        List errors;
        List warnings = engine.getWarnings();
        if (!warnings.isEmpty()) {
            StringBuilder buffer = new StringBuilder("JAXX detects " + (warnings.size() == 1 ? "1 warning" : warnings.size() + " warnings"));
            buffer.append(" :");
            for (String s : warnings) {
                buffer.append("\n").append(s);
            }
            this.getLog().warn((CharSequence)buffer.toString());
        }
        if (!(errors = engine.getErrors()).isEmpty()) {
            StringBuilder buffer = new StringBuilder("JAXX detects " + (errors.size() == 1 ? "1 error" : errors.size() + " errors"));
            buffer.append(" :");
            for (String s : errors) {
                buffer.append("\n").append(s);
            }
            this.getLog().error((CharSequence)buffer.toString());
        }
    }
}

