/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.nuiton.jaxx.runtime.swing.model.GenericListSelectionModel;

public class GenericListModel<B>
extends GenericListSelectionModel<B>
implements ComboBoxModel {
    public GenericListModel() {
        super(new DefaultListModel());
    }

    public GenericListModel(Collection<B> values) {
        this();
        this.setElements(values);
    }

    public void setElements(Collection<B> values) {
        Collection<B> oldValues = this.getElements();
        List oldSelectedValues = this.getSelectedValues();
        this.clearSelection();
        this.fireSelectionRemoved(oldSelectedValues);
        this.clearElements();
        this.fireValuesRemoved(oldValues);
        for (B value : values) {
            this.getListModel().addElement(value);
        }
        this.fireSelectionAdded(values);
    }

    public void clearElements() {
        Collection<B> elements = this.getElements();
        this.getListModel().clear();
        this.fireValuesRemoved(elements);
    }

    public Collection<B> getElements() {
        int size = this.getListModel().getSize();
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            result.add(this.getListModel().get(i));
        }
        return result;
    }

    public void addElement(int index, B valueToAdd) {
        this.getListModel().add(index, valueToAdd);
        this.fireValuesAdded(Lists.newArrayList((Object[])new Object[]{valueToAdd}));
    }

    public void addElement(B valueToAdd) {
        this.getListModel().addElement(valueToAdd);
        this.fireValuesAdded(Lists.newArrayList((Object[])new Object[]{valueToAdd}));
    }

    public void addElements(Collection<B> valuesToAdd) {
        for (B value : valuesToAdd) {
            this.getListModel().addElement(value);
        }
        this.fireValuesAdded(valuesToAdd);
    }

    public void removeElements(Collection<B> values) {
        for (B value : values) {
            this.getListModel().removeElement(value);
        }
        this.unSelectItems(values);
        this.fireValuesRemoved(values);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        List oldValue = this.getSelectedValues();
        this.fireSelectionRemoved(oldValue);
        this.setSelectedValues(Lists.newArrayList((Object[])new Object[]{anItem}));
        List newValues = this.getSelectedValues();
        this.fireSelectionAdded(newValues);
        this.fireContentsChanged(this, -1, -1);
        this.firePropertyChange("selectedValues", oldValue, newValues);
    }

    public B getSelectedItem() {
        List selectedValues = this.getSelectedValues();
        if (selectedValues.isEmpty()) {
            return null;
        }
        return selectedValues.get(0);
    }

    @Override
    public int getSize() {
        return this.getListModel().size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.getListModel().get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.getListModel().addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.getListModel().removeListDataListener(l);
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        ListDataListener[] listeners = this.getListModel().getListDataListeners();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            if (e == null) {
                e = new ListDataEvent(source, 0, index0, index1);
            }
            listeners[i + 1].contentsChanged(e);
        }
    }
}

