/*
 * *##%
 * JAXX Runtime
 * Copyright (C) 2008 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */
package jaxx.runtime.swing.navigation;

import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;

/**
 * Interface to create a builder, this object is design to build a
 * {@link NavigationModel}.
 *
 * @author sletellier
 * @since 2.0.0
 */
public interface NavigationModelBuilder {

    NavigationModel getModel();

    NavigationTreeNode buildEmptyRoot(JAXXContextEntryDef<?> entryDef,
                                      String contextName);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             String libelle,
                             JAXXContextEntryDef<?> entryDef,
                             String entryPath,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             String libelle,
                             JAXXContextEntryDef<?> entryDef,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             String libelle,
                             String entryPath,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             Decorator<?> decorator,
                             JAXXContextEntryDef<?> entryDef,
                             String entryPath,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             Decorator<?> decorator,
                             JAXXContextEntryDef<?> entryDef,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode build(NavigationTreeNode parentNode,
                             Decorator<?> decorator,
                             String entryPath,
                             String contextName,
                             Class<? extends JAXXObject> uiClass,
                             Class<? extends JAXXAction> actionClass);

    NavigationTreeNode removeChildNode(NavigationTreeNode node);

    void addI18nNodeRenderer(NavigationTreeNode node,
                             String libelle);

    void addDecoratorNodeRenderer(NavigationTreeNode node,
                                  Decorator<?> decorator);

    void addNodeJaxxClasses(
            NavigationTreeNode node,
            Class<? extends JAXXObject> uIClass,
            Class<? extends JAXXAction> uIHandlerClass);

    void printModel(NavigationTreeNode node);
}
