/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardOperationAction;
import jaxx.runtime.swing.wizard.WizardOperationModel;
import jaxx.runtime.swing.wizard.WizardOperationState;
import jaxx.runtime.swing.wizard.WizardOperationStep;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class WizardOperationActionThread<E extends WizardOperationStep, M extends WizardOperationModel<E>, A extends WizardOperationAction<E, M>>
extends Thread
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog(WizardOperationActionThread.class);
    private boolean canceled;
    protected Class<M> modelClass;
    protected A currentAction;
    private final Object LOCK = new Object();

    protected abstract M getModel();

    protected abstract JAXXContext getContext();

    public WizardOperationActionThread(Class<M> modelClass) throws IllegalArgumentException {
        super(WizardOperationActionThread.class.getSimpleName() + " " + new Date());
        this.modelClass = modelClass;
    }

    public void cancel() {
        log.info((Object)("cancel " + this));
        this.canceled = true;
        ((WizardOperationModel)this.getModel()).cancel();
        this.setWaiting(false);
    }

    public A launchOperation(E operation) {
        if (!(this.currentAction == null || ((SwingWorker)this.currentAction).isDone() && ((WizardOperationAction)this.currentAction).operationState != WizardOperationState.RUNNING)) {
            throw new IllegalStateException("can not add a operation when thread is busy, or has another operation to be done");
        }
        this.currentAction = ((WizardOperationModel)this.getModel()).getOperationAction(operation);
        this.setWaiting(false);
        return this.currentAction;
    }

    public A getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        SwingWorker.StateValue state;
        log.trace((Object)(evt.getPropertyName() + " <" + evt.getOldValue() + " - " + evt.getNewValue() + ">"));
        if ("state".equals(evt.getPropertyName()) && (state = (SwingWorker.StateValue)((Object)evt.getNewValue())) == SwingWorker.StateValue.DONE) {
            this.setWaiting(false);
        }
    }

    @Override
    public void run() {
        try {
            if (this.getModel() == null) {
                throw new NullPointerException("could not find model " + this.modelClass + " for " + this);
            }
            while (!this.canceled) {
                if (this.canceled) {
                    break;
                }
                this.setWaiting(true);
                log.trace((Object)("no more waiting " + this));
                if (this.canceled) continue;
                ((SwingWorker)this.currentAction).addPropertyChangeListener(this);
                ((WizardOperationModel)this.getModel()).setOperationState(WizardOperationState.RUNNING);
                ((WizardOperationAction)this.currentAction).start(this.getContext());
                this.setWaiting(true);
                if (this.canceled) {
                    ((WizardOperationModel)this.getModel()).setOperationState(WizardOperationState.CANCELED);
                } else {
                    ((WizardOperationModel)this.getModel()).setOperationState(((WizardOperationAction)this.currentAction).getOperationState());
                }
                ((SwingWorker)this.currentAction).removePropertyChangeListener(this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.unlockThread();
            log.trace((Object)(this + " will close..."));
            this.close();
        }
    }

    protected void close() {
        log.trace((Object)this);
    }

    protected void setWaiting(boolean waiting) {
        if (waiting && !this.canceled) {
            try {
                this.lockThread();
            }
            catch (InterruptedException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                this.canceled = true;
            }
        }
        if (!waiting) {
            this.unlockThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockThread() throws InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            log.trace((Object)this);
            this.LOCK.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockThread() {
        Object object = this.LOCK;
        synchronized (object) {
            log.trace((Object)this);
            this.LOCK.notify();
        }
    }
}

