/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.config.ConfigCategoryUI;
import org.nuiton.jaxx.config.ConfigTableEditor;
import org.nuiton.jaxx.config.ConfigTableRenderer;
import org.nuiton.jaxx.config.model.ConfigTableModel;
import org.nuiton.jaxx.config.model.OptionModel;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.swing.renderer.ClassTableCellRenderer;
import org.nuiton.jaxx.runtime.swing.renderer.ColorCellRenderer;

public class ConfigCategoryUIHandler {
    private static final Log log = LogFactory.getLog(ConfigCategoryUIHandler.class);
    private final ConfigCategoryUI ui;

    public ConfigCategoryUIHandler(ConfigCategoryUI ui) {
        this.ui = ui;
    }

    public void init() {
        JXTable table = this.ui.getTable();
        SwingUtil.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"config.key", (Object[])new Object[0]), I18n.n((String)"config.key.tip", (Object[])new Object[0]), I18n.n((String)"config.value", (Object[])new Object[0]), I18n.n((String)"config.value.tip", (Object[])new Object[0]), I18n.n((String)"config.defaultValue", (Object[])new Object[0]), I18n.n((String)"config.defaultValue.tip", (Object[])new Object[0])});
        ConfigTableRenderer renderer = new ConfigTableRenderer();
        SwingUtil.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)renderer);
        SwingUtil.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)renderer);
        Font f = table.getFont().deriveFont(3);
        int width = SwingUtil.computeTableColumnWidth((JTable)table, (Font)f, (int)0, (String)"___*");
        SwingUtil.fixTableColumnWidth((JTable)table, (int)0, (int)width);
        SwingUtil.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)new ConfigTableEditor((ConfigTableModel)table.getModel()));
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorCellRenderer());
        table.setDefaultRenderer(Class.class, (TableCellRenderer)new ClassTableCellRenderer());
    }

    public void updateDescriptionText() {
        OptionModel option;
        JXTable table = this.ui.getTable();
        JTextArea description = this.ui.getDescription();
        ListSelectionModel selectionModel = this.ui.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            option = null;
        } else {
            int row = selectionModel.getAnchorSelectionIndex();
            ConfigTableModel m = (ConfigTableModel)table.getModel();
            option = m.getEntry(row);
            if (log.isDebugEnabled()) {
                log.debug((Object)(row + " : " + option));
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (option == null) {
            buffer.append(I18n.t((String)"config.no.option.selected", (Object[])new Object[0]));
        } else {
            buffer.append(I18n.t((String)"config.option.label", (Object[])new Object[]{option.getKey(), I18n.t((String)option.getDescription(), (Object[])new Object[0])})).append('\n');
            if (option.isModified()) {
                String oValue = option.toString(option.getOriginalValue());
                String mValue = option.toString(option.getValue());
                buffer.append(I18n.t((String)"config.option.modified", (Object[])new Object[]{oValue, mValue})).append('\n');
            }
            if (option.isFinal()) {
                buffer.append(I18n.t((String)"config.option.final", (Object[])new Object[0])).append('\n');
            }
        }
        description.setText(buffer.toString());
    }

    public void copyCellValue() {
        JXTable table = this.ui.getTable();
        int[] selectedRows = table.getSelectedRows();
        int selectedRow = selectedRows[0];
        Integer selectedColumn = (Integer)this.ui.getCopyCellValue().getClientProperty("selectedColumn");
        ConfigTableModel tableModel = this.ui.getTableModel();
        OptionModel optionModel = tableModel.getEntry(selectedRow);
        Object value = null;
        switch (selectedColumn) {
            case 1: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will copy option value from " + optionModel.getKey()));
                }
                value = optionModel.getValue();
                break;
            }
            case 2: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will copy option default value from " + optionModel.getKey()));
                }
                value = optionModel.getOriginalValue();
            }
        }
        String text = "";
        if (value != null) {
            TableCellRenderer cellRenderer = table.getCellRenderer(selectedRow, selectedColumn.intValue());
            Component tableCellRendererComponent = cellRenderer.getTableCellRendererComponent((JTable)table, value, false, false, selectedRow, selectedColumn);
            text = ((JLabel)tableCellRendererComponent).getText();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy to clipboard cell (" + selectedRow + "-" + selectedColumn + ") value: \"" + text + "\""));
        }
        JAXXUtil.copyToClipBoard((String)text);
    }

    public void resetOptionValue() {
        JXTable table = this.ui.getTable();
        int[] selectedRows = table.getSelectedRows();
        int selectedRow = selectedRows[0];
        ConfigTableModel tableModel = this.ui.getTableModel();
        OptionModel optionModel = tableModel.getEntry(selectedRow);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will reset option: " + optionModel.getKey()));
        }
        tableModel.setValueAt(optionModel.getDefaultValue(), selectedRow, 1);
    }

    public void openTablePopupMenu(MouseEvent e, JPopupMenu popup) {
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            boolean stopEdit;
            boolean enableResetOptionValue;
            JXTable source = (JXTable)e.getSource();
            int[] selectedRows = source.getSelectedRows();
            int[] selectedColumns = source.getSelectedColumns();
            Point p = e.getPoint();
            int rowIndex = source.rowAtPoint(p);
            int columnIndex = source.columnAtPoint(p);
            if (rowIndex == -1) {
                source.clearSelection();
            } else if (!ArrayUtils.contains((int[])selectedRows, (int)rowIndex)) {
                source.setRowSelectionInterval(rowIndex, rowIndex);
            }
            if (columnIndex == -1) {
                source.clearSelection();
            } else if (!ArrayUtils.contains((int[])selectedColumns, (int)columnIndex)) {
                source.setColumnSelectionInterval(columnIndex, columnIndex);
            }
            int selectedRowCount = source.getSelectedRowCount();
            boolean enableCopyOptionValue = selectedRowCount == 1;
            boolean bl = enableResetOptionValue = selectedRowCount > 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("At point [" + p + "] found Row " + rowIndex + ", Column " + columnIndex));
            }
            boolean canContinue = true;
            if (source.isEditing() && !(stopEdit = source.getCellEditor().stopCellEditing())) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Could not stop edit cell...");
                }
                canContinue = false;
            }
            int selectedColumn = source.getSelectedColumn();
            this.ui.getCopyCellValue().putClientProperty("selectedColumn", selectedColumn);
            this.ui.getCopyCellValue().setEnabled(enableCopyOptionValue);
            this.ui.getResetOptionValue().setEnabled(enableResetOptionValue);
            if (canContinue) {
                popup.show((Component)source, e.getX(), e.getY());
            }
        }
    }
}

