/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.binding.DataBinding;

public class DataBindingHelper {
    public static boolean SHOW_LOG;
    protected static final Matcher leftBraceMatcher;
    protected static final Matcher rightBraceMatcher;
    protected final List<DataBinding> dataBindings = new ArrayList<DataBinding>();
    protected final List<DataBinding> simpleBindings = new ArrayList<DataBinding>();
    protected final JAXXCompiler compiler;
    protected final Map<String, Integer> autoUnsafeGenIds = new TreeMap<String, Integer>();

    public DataBindingHelper(JAXXCompiler compiler) {
        this.compiler = compiler;
    }

    public static String processDataBindings(String stringValue) throws CompilerException {
        int pos = DataBindingHelper.getNextLeftBrace(stringValue, 0);
        if (pos != -1) {
            StringBuilder expression = new StringBuilder();
            int lastPos = 0;
            while (pos != -1 && pos < stringValue.length()) {
                int pos2;
                boolean multi;
                if (pos > lastPos) {
                    if (expression.length() > 0) {
                        expression.append(" + ");
                    }
                    expression.append('\"');
                    expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos, pos)));
                    expression.append('\"');
                }
                boolean bl = multi = expression.length() > 0;
                if (multi) {
                    expression.append(" + ");
                    expression.append('(');
                }
                if ((pos2 = DataBindingHelper.getNextRightBrace(stringValue, pos + 1)) == -1) {
                    throw new CompilerException("unmatched '{' in expression: " + stringValue);
                }
                expression.append(stringValue.substring(pos + 1, pos2));
                if (multi) {
                    expression.append(')');
                }
                if (++pos2 < stringValue.length()) {
                    pos = DataBindingHelper.getNextLeftBrace(stringValue, pos2);
                    lastPos = pos2;
                    continue;
                }
                lastPos = pos = stringValue.length();
            }
            if (lastPos < stringValue.length()) {
                if (expression.length() > 0) {
                    expression.append(" + ");
                }
                expression.append('\"');
                expression.append(JAXXCompiler.escapeJavaString(stringValue.substring(lastPos)));
                expression.append('\"');
            }
            return expression.toString();
        }
        return null;
    }

    public DataBinding[] getDataBindings() {
        return this.dataBindings.toArray(new DataBinding[this.dataBindings.size()]);
    }

    public DataBinding[] getSimpleBindings() {
        return this.simpleBindings.toArray(new DataBinding[this.simpleBindings.size()]);
    }

    public void registerDataBinding(String id, String binding, String assignment) {
        binding = this.compiler.checkJavaCode(binding);
        this.registerDataBinding(new DataBinding(id, binding, assignment, true));
    }

    public void registerDataBinding(DataBinding binding) {
        this.dataBindings.add(binding);
    }

    public void clear() {
        this.simpleBindings.clear();
        this.dataBindings.clear();
        this.autoUnsafeGenIds.clear();
    }

    public String getSafeId(String id) {
        Integer integer = this.autoUnsafeGenIds.get(id);
        String result = id;
        if (integer == null) {
            integer = 0;
        } else {
            result = result + "_" + integer;
        }
        integer = integer + 1;
        this.autoUnsafeGenIds.put(id, integer);
        return result;
    }

    public void revertSafeId(String id) {
        Integer integer = this.autoUnsafeGenIds.get(id);
        if (integer != null) {
            Integer n = integer;
            integer = integer - 1;
            if (integer > 0) {
                this.autoUnsafeGenIds.put(id, integer);
            } else {
                this.autoUnsafeGenIds.remove(id);
            }
        }
    }

    public void finalizeBindings() {
        Iterator<DataBinding> itr = this.dataBindings.iterator();
        while (itr.hasNext()) {
            DataBinding binding = itr.next();
            boolean isBinding = binding.compile(this.compiler);
            if (isBinding) continue;
            this.simpleBindings.add(binding);
            itr.remove();
        }
    }

    protected static int getNextLeftBrace(String string, int pos) {
        leftBraceMatcher.reset(string);
        return leftBraceMatcher.find(pos) ? Math.max(leftBraceMatcher.start(1), leftBraceMatcher.start(2)) : -1;
    }

    protected static int getNextRightBrace(String string, int pos) {
        leftBraceMatcher.reset(string);
        rightBraceMatcher.reset(string);
        int openCount = 1;
        while (openCount > 0) {
            int rightPos;
            int leftPos = leftBraceMatcher.find(++pos) ? Math.max(leftBraceMatcher.start(1), leftBraceMatcher.start(2)) : -1;
            int n = rightPos = rightBraceMatcher.find(pos) ? Math.max(rightBraceMatcher.start(1), rightBraceMatcher.start(2)) : -1;
            assert (leftPos == -1 || leftPos >= pos);
            assert (rightPos == -1 || rightPos >= pos);
            if (leftPos != -1 && leftPos < rightPos) {
                pos = leftPos;
                ++openCount;
                continue;
            }
            if (rightPos != -1) {
                pos = rightPos;
                --openCount;
                continue;
            }
            openCount = 0;
        }
        return pos;
    }

    static {
        leftBraceMatcher = Pattern.compile("^(\\{)|[^\\\\](\\{)").matcher("");
        rightBraceMatcher = Pattern.compile("^(\\})|[^\\\\](\\})").matcher("");
    }
}

