/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.tags.swing;

import java.io.IOException;
import java.util.List;
import javax.swing.event.ListSelectionListener;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.tags.DefaultComponentHandler;
import jaxx.compiler.tags.swing.CompiledItemContainer;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.JAXXList;
import org.w3c.dom.Element;

public class JAXXListHandler
extends DefaultComponentHandler {
    public JAXXListHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(this.getClass(), beanClass, JAXXList.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        this.addProxyEventInfo("getSelectedIndex", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedIndices", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedValue", ListSelectionListener.class, "selectionModel");
        this.addProxyEventInfo("getSelectedValues", ListSelectionListener.class, "selectionModel");
    }

    @Override
    public CompiledObject createCompiledObject(String id, JAXXCompiler compiler) throws CompilerException {
        return new CompiledItemContainer(id, this.getBeanClass(), compiler);
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        super.compileChildrenSecondPass(tag, compiler);
        CompiledItemContainer list = (CompiledItemContainer)compiler.getOpenComponent();
        List<Item> items = list.getItems();
        if (items != null && !items.isEmpty()) {
            String listName = list.getId() + "$items";
            list.appendAdditionCode("java.util.List<jaxx.runtime.swing.Item> " + listName + " = new java.util.ArrayList<jaxx.runtime.swing.Item>();");
            for (Item item : items) {
                String id = item.getId();
                CompiledObject compiledItem = new CompiledObject(id, ClassDescriptorLoader.getClassDescriptor(Item.class), compiler);
                compiledItem.setConstructorParams(compiler.getJavaCode(id) + ", " + compiler.getJavaCode(item.getLabel()) + ", " + compiler.getJavaCode(item.getValue()) + ", " + item.isSelected());
                compiler.registerCompiledObject(compiledItem);
                list.appendAdditionCode(listName + ".add(" + id + ");");
            }
            list.appendAdditionCode(list.getId() + ".setItems(" + listName + ");");
        }
    }
}

