/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.CompilerException;
import jaxx.compiler.EventHandler;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.JAXXCompilerFinalizer;
import jaxx.compiler.binding.DataBinding;
import jaxx.compiler.java.JavaArgument;
import jaxx.compiler.java.JavaField;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorLoader;
import jaxx.compiler.reflect.FieldDescriptor;
import jaxx.compiler.reflect.MemberDescriptor;
import jaxx.compiler.reflect.MethodDescriptor;
import jaxx.runtime.Base64Coder;
import jaxx.runtime.DataBindingListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultFinalizer
implements JAXXCompilerFinalizer {
    protected static final Log log = LogFactory.getLog(DefaultFinalizer.class);
    protected static final JavaField SERIAL_VERSION_UID_FIELD = JavaFileGenerator.newField(26, "long", "serialVersionUID", false, "1L");
    protected static final JavaField ACTIVE_BINDINGS_FIELD = JavaFileGenerator.newField(4, "java.util.List<Object>", "$activeBindings", false, "new ArrayList<Object>()");
    protected static final JavaField BINDING_SOURCES_FIELD = JavaFileGenerator.newField(4, "java.util.Map<String,Object>", "$bindingSources", false, "new HashMap<String,Object>()");
    protected static final JavaField OBJECT_MAP_FIELD = JavaFileGenerator.newField(4, "Map<String,Object>", "$objectMap", true, "new HashMap<String,Object>()");
    protected static final JavaField ALL_COMPONENTS_CREATED_FIELD = JavaFileGenerator.newField(2, "boolean", "allComponentsCreated", false);
    protected static final JavaField CONTEXT_INITIALIZED = JavaFileGenerator.newField(2, "boolean", "contextInitialized", false, "true");
    protected static final JavaField PREVIOUS_VALUES_FIELD = JavaFileGenerator.newField(4, "java.util.Map<?,?>", "$previousValues", false, "new java.util.HashMap<Object,Object>()");
    protected static final JavaField PROPERTY_CHANGE_SUPPORT_FIELD = JavaFileGenerator.newField(0, "java.beans.PropertyChangeSupport", "$propertyChangeSupport", false);
    protected static final JavaMethod GET_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, null);", true, new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> T", "getContextValue", "return delegateContext.getContextValue(clazz, name);", true, new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, name);", true, new JavaArgument("T", "o"), new JavaArgument("String", "name"));
    protected static final JavaMethod SET_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "setContextValue", "delegateContext.setContextValue(o, null);", true, new JavaArgument("T", "o"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, name);", true, new JavaArgument("Class<T>", "clazz"), new JavaArgument("String", "name"));
    protected static final JavaMethod REMOVE_CONTEXT_VALUE_METHOD = JavaFileGenerator.newMethod(1, "<T> void", "removeContextValue", "delegateContext.removeContextValue(clazz, null);", true, new JavaArgument("Class<T>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_MORE_METHOD = JavaFileGenerator.newMethod(1, "<O extends Container> O", "getParentContainer", "return Util.getParentContainer(source, clazz);", true, new JavaArgument("Object", "source"), new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_PARENT_CONTAINER_METHOD = JavaFileGenerator.newMethod(1, "<O extends Container> O", "getParentContainer", "return Util.getParentContainer(this, clazz);", true, new JavaArgument("Class<O>", "clazz"));
    protected static final JavaMethod GET_OBJECT_BY_ID_METHOD = JavaFileGenerator.newMethod(1, "java.lang.Object", "getObjectById", "return $objectMap.get(id);", true, new JavaArgument("String", "id"));
    protected static final JavaMethod GET_JAXX_OBJECT_DESCRIPTOR_METHOD = JavaFileGenerator.newMethod(9, "jaxx.runtime.JAXXObjectDescriptor", "$getJAXXObjectDescriptor", "return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);", false, new JavaArgument[0]);
    protected static final JavaMethod PROCESS_DATA_BINDING_METHOD = JavaFileGenerator.newMethod(1, "void", "processDataBinding", "processDataBinding(dest, false);", true, new JavaArgument("String", "dest"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_METHOD = JavaFileGenerator.newMethod(1, "void", "firePropertyChange", "super.firePropertyChange(propertyName, oldValue, newValue);", true, new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod FIRE_PROPERTY_CHANGE_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "firePropertyChange", "$getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);", true, new JavaArgument("String", "propertyName"), new JavaArgument("Object", "oldValue"), new JavaArgument("Object", "newValue"));
    protected static final JavaMethod GET_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(0, "java.beans.PropertyChangeSupport", "$getPropertyChangeSupport", "if ($propertyChangeSupport == null)\n    $propertyChangeSupport = new PropertyChangeSupport(this);\nreturn $propertyChangeSupport;", false, new JavaArgument[0]);
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(listener);", true, new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "addPropertyChangeListener", "$getPropertyChangeSupport().addPropertyChangeListener(property, listener);", true, new JavaArgument("String", "property"), new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD = JavaFileGenerator.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(listener);", true, new JavaArgument("java.beans.PropertyChangeListener", "listener"));
    protected static final JavaMethod REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD = JavaFileGenerator.newMethod(1, "void", "removePropertyChangeListener", "$getPropertyChangeSupport().removePropertyChangeListener(property, listener);", true, new JavaArgument("String", "property"), new JavaArgument("java.beans.PropertyChangeListener", "listener"));

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
        String fullClassName;
        String string = fullClassName = packageName != null ? packageName + "." + className : className;
        if (root == null) {
            throw new CompilerException("root tag must be a class tag");
        }
        ClassDescriptor superclass = root.getObjectClass();
        boolean superclassIsJAXXObject = ClassDescriptorLoader.getClassDescriptor(JAXXObject.class).isAssignableFrom(superclass);
        javaFile.setModifiers(1);
        javaFile.setName(fullClassName);
        javaFile.setSuperClass(JAXXCompiler.getCanonicalName(superclass));
        javaFile.setSuperclassIsJAXXObject(superclassIsJAXXObject);
        javaFile.addInterfaces(compiler.getExtraInterfaces());
        javaFile.setAbstractClass(compiler.isAbstractClass());
        javaFile.setGenericType(compiler.getGenericType());
        javaFile.setSuperGenericType(compiler.getSuperGenericType());
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            decorator.finalizeCompiler(compiler, root, object, javaFile, packageName, className, fullClassName);
        }
        this.finalizeBindings(compiler, superclassIsJAXXObject);
        if (!superclassIsJAXXObject) {
            javaFile.addInterface(JAXXCompiler.getCanonicalName(JAXXObject.class));
        }
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        MethodDescriptor[] methods;
        FieldDescriptor[] scriptFields;
        String fullClassName = javaFile.getName();
        String jaxxContextImplementorClass = compiler.getConfiguration().getJaxxContextClass().getName();
        boolean superclassIsJAXXObject = javaFile.isSuperclassIsJAXXObject();
        if (!superclassIsJAXXObject) {
            if (compiler.getConfiguration().isAddLogger()) {
                javaFile.addImport(Log.class);
                javaFile.addImport(LogFactory.class);
                javaFile.addSimpleField(JavaFileGenerator.newField(25, "Log", "log", false, "LogFactory.getLog(" + fullClassName + ".class)"));
            }
            javaFile.addField(OBJECT_MAP_FIELD);
            javaFile.addMethod(GET_OBJECT_BY_ID_METHOD);
            javaFile.addField(BINDING_SOURCES_FIELD);
            javaFile.addField(ACTIVE_BINDINGS_FIELD);
            javaFile.addField(JavaFileGenerator.newField(20, JAXXContext.class.getName(), "delegateContext", true, "new " + jaxxContextImplementorClass + "()"));
            javaFile.addMethod(SET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(SET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(GET_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_METHOD);
            javaFile.addMethod(REMOVE_CONTEXT_VALUE_NAMED_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_METHOD);
            javaFile.addMethod(GET_PARENT_CONTAINER_MORE_METHOD);
            this.addPropertyChangeSupport(root, javaFile);
            javaFile.addMethod(PROCESS_DATA_BINDING_METHOD);
        }
        javaFile.addSimpleField(SERIAL_VERSION_UID_FIELD);
        javaFile.addSimpleField(ALL_COMPONENTS_CREATED_FIELD);
        boolean overrideContextInitialized = false;
        for (FieldDescriptor f : scriptFields = compiler.getScriptFields()) {
            if (!"contextInitialized".equals(f.getName())) continue;
            overrideContextInitialized = true;
            break;
        }
        if (!overrideContextInitialized) {
            javaFile.addSimpleField(CONTEXT_INITIALIZED);
        }
        javaFile.addSimpleField(this.createJAXXObjectDescriptorField(compiler, javaFile));
        if (compiler.getStylesheet() != null) {
            boolean needField = true;
            if (superclassIsJAXXObject) {
                JAXXCompiler parentCompiler;
                ClassDescriptor superclass = root.getObjectClass();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("superclass : " + superclass));
                }
                if ((parentCompiler = compiler.getEngine().getJAXXCompiler(superclass.getName())) != null) {
                    needField = parentCompiler.getStylesheet() == null;
                } else {
                    try {
                        superclass.getDeclaredFieldDescriptor(PREVIOUS_VALUES_FIELD.getName());
                        needField = false;
                    }
                    catch (NoSuchFieldException ex) {
                        // empty catch block
                    }
                }
                if (needField && log.isDebugEnabled()) {
                    log.debug((Object)("no " + PREVIOUS_VALUES_FIELD.getName() + " field in super class"));
                }
            }
            if (needField) {
                javaFile.addSimpleField(PREVIOUS_VALUES_FIELD);
            }
        }
        boolean constructorDetected = false;
        for (MethodDescriptor m : methods = compiler.getScriptMethods()) {
            try {
                m.getReturnType();
                if (!className.equals(m.getName())) continue;
                constructorDetected = true;
                break;
            }
            catch (Exception e) {
                log.warn((Object)("could not find return type " + m));
            }
        }
        if (!constructorDetected) {
            javaFile.addMethod(this.createConstructor(compiler, className, superclassIsJAXXObject));
            javaFile.addMethod(this.createConstructorWithInitialContext(compiler, className, superclassIsJAXXObject));
        }
        javaFile.addMethod(this.createInitializer(compiler));
        javaFile.addMethod(GET_JAXX_OBJECT_DESCRIPTOR_METHOD);
        javaFile.addBodyCode(compiler.getBodyCode().toString());
        javaFile.addMethod(this.createCompleteSetupMethod(compiler, javaFile, compiler.getInitDataBindings()));
        javaFile.addMethod(JavaFileGenerator.newMethod(1, "void", "applyDataBinding", compiler.getApplyDataBinding().toString() + JAXXCompiler.getLineSeparator() + "processDataBinding($binding);", true, new JavaArgument("String", "$binding")));
        javaFile.addMethod(JavaFileGenerator.newMethod(1, "void", "removeDataBinding", compiler.getRemoveDataBinding().toString(), true, new JavaArgument("String", "$binding")));
        javaFile.addMethod(this.createProcessDataBindingMethod(compiler, superclassIsJAXXObject));
        this.addEventHandlers(compiler, javaFile);
    }

    protected void finalizeBindings(JAXXCompiler compiler, boolean superclassIsJAXXObject) {
        String eol = JAXXCompiler.getLineSeparator();
        if (compiler.getDataBindings() != null && !compiler.getDataBindings().isEmpty()) {
            compiler.addImport(DataBindingListener.class.getName());
        }
        for (DataBinding dataBinding : compiler.getDataBindings()) {
            if (!dataBinding.compile(compiler, true)) continue;
            String expression = "applyDataBinding(" + compiler.getJavaCode(dataBinding.getId()) + ");" + eol;
            compiler.appendInitDataBindings(expression);
        }
        if (superclassIsJAXXObject) {
            boolean hasBind = compiler.hasApplyDataBinding();
            if (hasBind) {
                compiler.appendApplyDataBinding(" else {");
                compiler.appendApplyDataBinding(eol);
                compiler.appendApplyDataBinding("    ");
            }
            compiler.appendApplyDataBinding("super.applyDataBinding($binding);");
            compiler.appendApplyDataBinding(eol);
            if (hasBind) {
                compiler.appendApplyDataBinding("    return;");
                compiler.appendApplyDataBinding(eol);
                compiler.appendApplyDataBinding("}");
            }
            if (hasBind = compiler.hasRemoveDataBinding()) {
                compiler.appendRemoveDataBinding(" else {");
                compiler.appendRemoveDataBinding(eol);
                compiler.appendRemoveDataBinding("    ");
            }
            compiler.appendRemoveDataBinding("super.removeDataBinding($binding);");
            compiler.appendRemoveDataBinding(eol);
            if (hasBind) {
                compiler.appendRemoveDataBinding("}");
            }
        }
    }

    protected JavaField createJAXXObjectDescriptorField(JAXXCompiler compiler, JavaFile javaFile) {
        try {
            JAXXObjectDescriptor descriptor = compiler.getJAXXObjectDescriptor();
            String data = Base64Coder.serialize((Object)descriptor, (boolean)true);
            int sizeLimit = 65000;
            if (data.length() < sizeLimit) {
                return JavaFileGenerator.newField(10, "String", "$jaxxObjectDescriptor", false, compiler.getJavaCode(data));
            }
            StringBuffer initializer = new StringBuffer();
            for (int i = 0; i < data.length(); i += sizeLimit) {
                String name = "$jaxxObjectDescriptor" + i;
                javaFile.addField(new JavaField(10, "String", name, false, compiler.getJavaCode(data.substring(i, Math.min(i + sizeLimit, data.length())))));
                if (initializer.length() > 0) {
                    initializer.append(" + ");
                }
                initializer.append("String.valueOf(").append(name).append(")");
            }
            return JavaFileGenerator.newField(26, "String", "$jaxxObjectDescriptor", false, initializer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    protected void addPropertyChangeSupport(CompiledObject root, JavaFile javaFile) {
        int modifiers;
        ClassDescriptor currentClass = root.getObjectClass();
        MemberDescriptor firePropertyChange = null;
        while (firePropertyChange == null && currentClass != null) {
            try {
                firePropertyChange = currentClass.getDeclaredMethodDescriptor("firePropertyChange", ClassDescriptorLoader.getClassDescriptor(String.class), ClassDescriptorLoader.getClassDescriptor(Object.class), ClassDescriptorLoader.getClassDescriptor(Object.class));
            }
            catch (NoSuchMethodException e) {
                currentClass = currentClass.getSuperclass();
            }
        }
        int n = modifiers = firePropertyChange != null ? firePropertyChange.getModifiers() : 0;
        if (Modifier.isPublic(modifiers)) {
            return;
        }
        if (Modifier.isProtected(modifiers)) {
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_METHOD);
        } else {
            javaFile.addField(PROPERTY_CHANGE_SUPPORT_FIELD);
            javaFile.addMethod(GET_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(ADD_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_METHOD);
            javaFile.addMethod(REMOVE_PROPERTY_CHANGE_SUPPORT_NAMED_METHOD);
            javaFile.addMethod(FIRE_PROPERTY_CHANGE_NAMED_METHOD);
        }
    }

    protected void addEventHandlers(JAXXCompiler compiler, JavaFile javaFile) {
        for (Map.Entry<String, Map<ClassDescriptor, List<EventHandler>>> e1 : compiler.getEventHandlers().entrySet()) {
            for (Map.Entry<ClassDescriptor, List<EventHandler>> e2 : e1.getValue().entrySet()) {
                for (EventHandler handler : e2.getValue()) {
                    String methodName = compiler.getEventHandlerMethodName(handler);
                    MethodDescriptor listenerMethod = handler.getListenerMethod();
                    if (listenerMethod.getParameterTypes().length != 1) {
                        throw new CompilerException("Expected event handler " + listenerMethod.getName() + " of class " + handler.getListenerClass() + " to have exactly one argument");
                    }
                    javaFile.addMethod(JavaFileGenerator.newMethod(1, "void", methodName, handler.getJavaCode(), false, new JavaArgument(JAXXCompiler.getCanonicalName(listenerMethod.getParameterTypes()[0]), "event")));
                }
            }
        }
    }

    protected JavaMethod createConstructor(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        if (constructorParams != null) {
            code.append("        super(").append(constructorParams).append(");").append(eol);
        } else if (superclassIsJAXXObject) {
            code.append("        super();").append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        return JavaFileGenerator.newMethod(1, null, className, code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createConstructorWithInitialContext(JAXXCompiler compiler, String className, boolean superclassIsJAXXObject) throws CompilerException {
        StringBuffer code = new StringBuffer();
        String constructorParams = compiler.getRootObject().getConstructorParams();
        String eol = JAXXCompiler.getLineSeparator();
        if (constructorParams != null) {
            if (superclassIsJAXXObject) {
                constructorParams = "parentContext, " + constructorParams;
            }
            code.append("        super(").append(constructorParams).append(");").append(eol);
        } else if (superclassIsJAXXObject) {
            code.append("        super(parentContext);").append(eol);
        }
        if (!superclassIsJAXXObject) {
            code.append(Util.class.getName()).append(".initContext(this, parentContext);");
            code.append(eol);
        }
        code.append("$initialize();");
        code.append(eol);
        return JavaFileGenerator.newMethod(1, null, className, code.toString(), false, new JavaArgument(JAXXContext.class.getName(), "parentContext"));
    }

    public JavaMethod createInitializer(JAXXCompiler compiler) throws CompilerException {
        String eol = JAXXCompiler.getLineSeparator();
        StringBuffer code = new StringBuffer();
        CompiledObject root = compiler.getRootObject();
        code.append("if (allComponentsCreated || !contextInitialized) {");
        code.append(eol);
        code.append("    return;");
        code.append(eol);
        code.append("}");
        code.append(eol);
        code.append("$objectMap.put(").append(compiler.getJavaCode(root.getId())).append(", this);");
        code.append(eol);
        Iterator<CompiledObject> i = compiler.getObjectCreationOrder();
        boolean lastWasMethodCall = false;
        while (i.hasNext()) {
            CompiledObject object = i.next();
            if (object == root) continue;
            CompiledObjectDecorator decorator = object.getDecorator();
            lastWasMethodCall = decorator.createInitializer(compiler, root, object, code, lastWasMethodCall);
        }
        root.getDecorator().createInitializer(compiler, root, root, code, lastWasMethodCall);
        if (compiler.getInitializer().length() > 0) {
            code.append(compiler.getInitializer());
        }
        code.append("$completeSetup();");
        code.append(eol);
        return JavaFileGenerator.newMethod(2, "void", "$initialize", code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createCompleteSetupMethod(JAXXCompiler compiler, JavaFile javaFile, StringBuffer initDataBindings) {
        MethodDescriptor method;
        StringBuffer code = new StringBuffer();
        code.append("allComponentsCreated = true;");
        String eol = JAXXCompiler.getLineSeparator();
        code.append(eol);
        for (CompiledObject object : compiler.getObjects().values()) {
            CompiledObjectDecorator decorator = object.getDecorator();
            code.append(decorator.createCompleteSetupMethod(compiler, object, javaFile, initDataBindings));
        }
        code.append("// init data bindings").append(eol);
        code.append(initDataBindings);
        if (compiler.getLateInitializer().length() > 0) {
            code.append("// late initializer").append(eol);
            code.append(compiler.getLateInitializer()).append(eol);
        }
        if ((method = compiler.getScriptMethod("$afterCompleteSetup")) != null) {
            code.append("$afterCompleteSetup();").append(eol);
        }
        return JavaFileGenerator.newMethod(2, "void", "$completeSetup", code.toString(), false, new JavaArgument[0]);
    }

    protected JavaMethod createProcessDataBindingMethod(JAXXCompiler compiler, boolean superclassIsJAXXObject) {
        StringBuffer code = new StringBuffer();
        String eol = JAXXCompiler.getLineSeparator();
        if (compiler.getProcessDataBinding().length() > 0) {
            code.append("    if (!$force && $activeBindings.contains($dest)) { ");
            code.append(eol);
            code.append("    return;").append(eol);
            code.append("}").append(eol);
            code.append("$activeBindings.add($dest);").append(eol);
            code.append("try {").append(eol);
            code.append(compiler.getProcessDataBinding().toString());
            if (superclassIsJAXXObject) {
                code.append(" else {").append(eol);
                code.append("        super.processDataBinding($dest, true);").append(eol);
                code.append("    }");
            }
            code.append(eol);
            code.append("} finally {").append(eol);
            code.append("    $activeBindings.remove($dest);").append(eol);
            code.append("}").append(eol);
        } else if (superclassIsJAXXObject) {
            code.append("super.processDataBinding($dest, true);").append(eol);
        }
        return JavaFileGenerator.newMethod(1, "void", "processDataBinding", code.toString(), superclassIsJAXXObject, new JavaArgument("String", "$dest"), new JavaArgument("boolean", "$force"));
    }
}

