/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.types;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import jaxx.compiler.types.TypeConverter;

public class TypeManager {
    private static Map<Class<?>, TypeConverter> converters;

    public static Map<Class<?>, TypeConverter> getConverters() {
        if (converters == null) {
            converters = new HashMap();
            ServiceLoader<TypeConverter> loader = ServiceLoader.load(TypeConverter.class);
            for (TypeConverter c : loader) {
                for (Class<?> type : c.getSupportedTypes()) {
                    converters.put(type, c);
                }
            }
        }
        return converters;
    }

    private TypeManager() {
    }

    public static TypeConverter getTypeConverter(Class<?> type) {
        return TypeManager.getConverters().get(type);
    }

    public static String getJavaCode(Object object) {
        if (object == null) {
            return "null";
        }
        TypeConverter converter = TypeManager.getTypeConverter(object.getClass());
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + object.getClass());
        }
        return converter.getJavaCode(object);
    }

    public static Object convertFromString(String string, Class<?> type) {
        TypeConverter converter = TypeManager.getTypeConverter(type);
        if (converter == null) {
            throw new IllegalArgumentException("unsupported type: " + type);
        }
        return converter.convertFromString(string, type);
    }
}

