/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.action;

import com.google.common.base.Preconditions;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import jaxx.runtime.FileChooserUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationConfiguration;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.action.ApplicationActionEngine;
import org.nuiton.jaxx.application.swing.action.ApplicationActionFactory;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;

public abstract class AbstractApplicationAction<M extends AbstractBean, UI extends ApplicationUI<M, ?>, H extends AbstractApplicationUIHandler<M, UI>>
extends AbstractBean {
    private static final Log log = LogFactory.getLog(AbstractApplicationAction.class);
    public static final String PROPERTY_DONE = "done";
    protected final H handler;
    protected String actionDescription;
    protected final boolean hideBody;
    protected final Object lock = new Object();

    public abstract void doAction() throws Exception;

    protected AbstractApplicationAction(H handler, boolean hideBody) {
        this.handler = handler;
        this.hideBody = hideBody;
    }

    public boolean prepareAction() throws Exception {
        return true;
    }

    protected void releaseAction() {
        this.firePropertyChange(PROPERTY_DONE, null, true);
    }

    public void postSuccessAction() {
    }

    public void postFailedAction(Throwable error) {
    }

    public H getHandler() {
        return this.handler;
    }

    public M getModel() {
        return (M)((AbstractBean)((AbstractApplicationUIHandler)this.handler).getModel());
    }

    public final UI getUI() {
        return ((AbstractApplicationUIHandler)this.handler).getUI();
    }

    public ApplicationUIContext getContext() {
        return ((AbstractApplicationUIHandler)this.handler).getContext();
    }

    public String getActionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String actionDescription) {
        this.actionDescription = actionDescription;
    }

    public void setProgressionModel(ApplicationProgressionModel progressionModel) {
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
    }

    protected ApplicationProgressionModel getProgressionModel() {
        return this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public boolean isHideBody() {
        return this.hideBody;
    }

    protected ApplicationConfiguration getConfig() {
        return this.getContext().getConfiguration();
    }

    protected abstract void sendMessage(String var1);

    protected <O> Decorator<O> getDecorator(Class<O> type, String name) {
        Decorator<O> decorator = ((AbstractApplicationUIHandler)this.handler).getDecorator(type, name);
        Preconditions.checkNotNull(decorator);
        return decorator;
    }

    protected String decorate(Object object) {
        return this.getDecorator(object.getClass(), null).toString(object);
    }

    protected String decorate(Object object, String context) {
        return this.getDecorator(object.getClass(), context).toString(object);
    }

    protected File chooseFile(String title, String buttonLabel, String ... filters) {
        File file = FileChooserUtil.getFile((String)title, (String)buttonLabel, (Component)this.getContext().getMainUI(), (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            File newDir = file.isDirectory() ? file : file.getParentFile();
            FileChooserUtil.setCurrentDirectory((File)newDir);
        }
        return file;
    }

    protected File saveFile(File defaultFile, String filename, String extension, String title, String buttonLabel, String ... filters) {
        if (defaultFile != null && FileChooserUtil.isCurrentDirectoryDefault()) {
            FileChooserUtil.setCurrentDirectory((File)defaultFile);
        }
        File file = this.saveFile(filename, extension, title, buttonLabel, filters);
        return file;
    }

    protected File saveFile(String filename, String extension, String title, String buttonLabel, String ... filters) {
        boolean withExtension = StringUtils.isNotBlank((CharSequence)extension);
        String filenameSuffix = withExtension ? "." + extension : "";
        File file = FileChooserUtil.saveFile((String)(filename + filenameSuffix), (String)title, (String)buttonLabel, (Component)this.getContext().getMainUI(), (String[])filters);
        if (log.isDebugEnabled()) {
            log.debug((Object)(title + " : " + file));
        }
        if (file != null) {
            boolean confirm;
            Preconditions.checkState((!file.isDirectory() ? 1 : 0) != 0);
            if (withExtension && !file.getName().endsWith(filenameSuffix)) {
                file = new File(file.getParentFile(), file.getName() + filenameSuffix);
            }
            if (confirm = this.askOverwriteFile(file)) {
                FileChooserUtil.setCurrentDirectory((File)file.getParentFile());
            } else {
                file = null;
            }
        }
        return file;
    }

    protected boolean askOverwriteFile(File file) {
        boolean result;
        if (file.exists()) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"jaxx.application.common.askOverwriteFile.message", (Object[])new Object[]{file}), I18n.t((String)"jaxx.application.common.askOverwriteFile.help", (Object[])new Object[0]));
            result = JOptionPane.showConfirmDialog(((AbstractApplicationUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"jaxx.application.common.askOverwriteFile.title", (Object[])new Object[0]), 2, 3) == 0;
        } else {
            result = true;
        }
        return result;
    }

    protected boolean askBeforeDelete(String title, String message) {
        String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", message, I18n.t((String)"jaxx.application.common.askBeforeDelete.help", (Object[])new Object[0]));
        int i = JOptionPane.showConfirmDialog(((AbstractApplicationUIHandler)this.getHandler()).getTopestUI(), htmlMessage, title, 2, 3);
        boolean result = i == 0;
        return result;
    }

    protected void displayInfoMessage(String title, String message) {
        JOptionPane.showMessageDialog(((AbstractApplicationUIHandler)this.getHandler()).getTopestUI(), message, title, 1);
    }

    protected void displayWarningMessage(String title, String message) {
        JOptionPane.showMessageDialog(((AbstractApplicationUIHandler)this.getHandler()).getTopestUI(), message, title, 2);
    }

    protected void createProgressionModelIfRequired(int total) {
        ApplicationProgressionModel progressionModel = this.getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ApplicationProgressionModel();
            progressionModel.setTotal(total);
            progressionModel.setMessage("");
            progressionModel.setCurrent(0);
            this.setProgressionModel(progressionModel);
        } else {
            progressionModel.adaptTotal(total);
        }
    }

    public ApplicationActionFactory getActionFactory() {
        return this.getContext().getActionFactory();
    }

    public ApplicationActionEngine getActionEngine() {
        return this.getContext().getActionEngine();
    }
}

