/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18nLanguage;
import org.nuiton.i18n.bundle.I18nBundle;
import org.nuiton.i18n.bundle.I18nBundleEntry;
import org.nuiton.i18n.bundle.I18nBundleUtil;
import org.nuiton.i18n.init.I18nInitializer;

public class I18nStore {
    private static final Log log = LogFactory.getLog(I18nStore.class);
    protected I18nLanguage language;
    protected Map<Locale, I18nLanguage> languages;
    protected I18nBundle[] bundles;
    protected Locale defaultLocale;
    protected I18nInitializer resolver;

    public I18nStore(Locale defaultLocale, I18nInitializer resolver) {
        this.defaultLocale = defaultLocale == null ? Locale.getDefault() : defaultLocale;
        this.resolver = resolver;
    }

    public I18nLanguage getCurrentLanguage() {
        return this.language;
    }

    public Locale getCurrentLocale() {
        return this.language == null ? null : this.language.getLocale();
    }

    public void setCurrentLocale(Locale locale) {
        I18nLanguage result;
        Locale currentLocale = this.getCurrentLocale();
        if (locale.equals(currentLocale)) {
            return;
        }
        this.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)("locale: " + locale));
        }
        this.language = result = this.getLanguage(locale);
        Locale.setDefault(locale);
    }

    @Deprecated
    public I18nLanguage getLanguage() {
        return this.language;
    }

    public I18nLanguage[] getLanguages() {
        Collection<I18nLanguage> values = this.getLanguagesCache().values();
        return values.toArray(new I18nLanguage[values.size()]);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public boolean isEmpty() {
        boolean isEmpty = I18nBundleUtil.isEmpty(this.getBundles());
        return isEmpty;
    }

    public Locale[] getLocales() {
        Locale[] result = I18nBundleUtil.getLocales(this.getBundles());
        return result;
    }

    public I18nBundle[] getBundles() {
        this.checkInit();
        return this.bundles;
    }

    public I18nBundle[] getBundles(Locale l) {
        I18nBundle[] result = I18nBundleUtil.getBundles(l, this.getBundles());
        return result;
    }

    public I18nBundleEntry[] getBundleEntries() {
        I18nBundleEntry[] result = I18nBundleUtil.getBundleEntries(this.getBundles());
        return result;
    }

    public I18nBundleEntry[] getBundleEntries(Locale l) {
        I18nBundleEntry[] result = I18nBundleUtil.getBundleEntries(l, this.getDefaultLocale(), this.getBundles());
        return result;
    }

    protected void init() {
        if (this.isInit()) {
            return;
        }
        if (this.resolver == null) {
            throw new NullPointerException("resolver can not be null in org.nuiton.i18n.I18nStore.init method");
        }
        try {
            this.bundles = this.resolver.resolvBundles();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not init store for reason " + e.getMessage(), e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.bundles.length + " bundle(s) found, [" + this.getBundleEntries().length + " file(s)]."));
        }
    }

    @Deprecated
    protected void setLanguage(Locale locale) {
        I18nLanguage result;
        this.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)("locale: " + locale));
        }
        this.language = result = this.getLanguage(locale);
        Locale.setDefault(locale);
    }

    protected void close() {
        if (this.languages != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will close " + this.languages.size() + " language(s)."));
            }
            for (I18nLanguage l : this.languages.values()) {
                l.close();
            }
            this.languages.clear();
            this.languages = null;
        }
        if (this.bundles != null) {
            this.bundles = null;
        }
        this.language = null;
    }

    protected Map<Locale, I18nLanguage> getLanguagesCache() {
        if (this.languages == null) {
            this.languages = new HashMap<Locale, I18nLanguage>();
        }
        return this.languages;
    }

    protected I18nLanguage getLanguage(Locale locale) {
        I18nLanguage result = null;
        if (MapUtils.isNotEmpty(this.languages)) {
            result = this.languages.get(locale);
        }
        if (result == null) {
            result = this.addLanguage(locale);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("using cached language : " + result));
        }
        return result;
    }

    protected I18nLanguage addLanguage(Locale locale) {
        if (!this.isInit()) {
            this.init();
        }
        I18nLanguage result = new I18nLanguage(locale);
        I18nBundleEntry[] entries = this.getBundleEntries(locale);
        result.load(entries, this.resolver.getEncoding());
        if (log.isInfoEnabled()) {
            log.info((Object)(result + ", nbEntries: " + entries.length + ", nbSentences: " + result.size() + "."));
        }
        this.getLanguagesCache().put(locale, result);
        return result;
    }

    protected boolean isInit() {
        return this.bundles != null;
    }

    protected void checkInit() {
        if (!this.isInit()) {
            throw new IllegalStateException("should call init method on " + I18nStore.class);
        }
    }

    public I18nInitializer getResolver() {
        return this.resolver;
    }
}

