package org.nuiton.eugene.plugin.modelextension;

/*-
 * #%L
 * EUGene :: Maven plugin
 * %%
 * Copyright (C) 2006 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 * Created on 10/09/16.
 *
 * @author Tony Chemit - chemit@codelutin.com
 */
public class ClassBean extends ElementBean {

    protected final Set<AttributeBean> attributes;

    public ClassBean(String name) {
        super(name);
        this.attributes = new TreeSet<>();
    }

    public Set<AttributeBean> getAttributes() {
        return attributes;
    }

    public Map<String, String> getAttributesTagValues() {
        Map<String, String> attributesTagValues = new TreeMap<>();
        for (AttributeBean attributeBean : attributes) {

            for (Map.Entry<String, String> entry : attributeBean.tagValues.entrySet()) {
                attributesTagValues.put(attributeBean.name + "." + entry.getKey(), entry.getValue());
            }
        }
        return attributesTagValues;
    }

    public Set<String> getAttributesStereotypes() {
        Set<String> attributesStereotypes = new TreeSet<>();
        for (AttributeBean attributeBean : attributes) {

            for (String entry : attributeBean.stereotypes) {
                attributesStereotypes.add(attributeBean.name + "." + entry);
            }
        }
        return attributesStereotypes;
    }

    public AttributeBean getOrCreateAttribute(String attributeName) {
        AttributeBean result = null;
        for (AttributeBean attributeBean : attributes) {
            if (attributeName.equals(attributeBean.name)) {
                result = attributeBean;
                break;
            }
        }
        if (result == null) {
            result = new AttributeBean(attributeName);
            attributes.add(result);
        }
        return result;
    }
}
