package org.nuiton.eugene.java;

/*
 * #%L
 * EUGene :: Java templates
 * %%
 * Copyright (C) 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.ImmutableSet;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.matcher.EqualsTagValueNameMatcher;
import org.nuiton.eugene.models.extension.tagvalue.provider.DefaultTagValueMetadatasProvider;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelPackage;

import java.util.Set;

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

/**
 * Defines all tag values managed by Java templates.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @plexus.component role="org.nuiton.eugene.models.extension.tagvalue.provider.TagValueMetadatasProvider" role-hint="simpleJavaBeanWithNoInterface"
 * @since 2.5.6
 */
public class SimpleJavaBeanWithNoInterfaceTransformerTagValues extends DefaultTagValueMetadatasProvider {

    @Override
    public String getDescription() {
        return t("eugene.simpleBeanWithNoInterfaceTransformer.tagvalues");
    }

    public enum Store implements TagValueMetadata {

        /**
         * To generate a factory of generated simple beans.
         *
         * You must use it on the complete model.
         *
         * @see #isSimpleBeanWithNoInterfaceSkipGenerateDefaults(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceGenerateDefaults(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceGenerateDefaults"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),


        /**
         * To generate or not guava predicates on each property of the bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #isSimpleBeanWithNoInterfaceSkipGeneratePredicates(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceGeneratePredicates(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceGeneratePredicates"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To generate or not guava functions on each property of the bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #isSimpleBeanWithNoInterfaceSkipGenerateFunctions(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceGenerateFunctions(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceGenerateFunctions"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To generate or not constructors methods on Default classes.
         *
         * You can globaly use it on the complete model, package or on a specific classifier.
         *
         * @see #isSimpleBeanWithNoInterfaceSkipGenerateDefaultConstructors(ObjectModelClassifier, ObjectModelPackage, ObjectModel)}
         * @since 3.0
         */
        simpleBeanWithNoInterfaceSkipGenerateConstructors(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceGenerateConstructors"), boolean.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * Tag value to use a super class for generated bean.
         *
         * If the bean needs Property change support (says you use the tag-value {@link EugeneJavaTagValues.Store#generatePropertyChangeSupport},
         * then your class must provide evrything for it.
         *
         * More over, if you use some collections in your bean you must also define
         * two method named {@code getChild(Collection list, int index)} and
         * {@code getChild(List list, int index)}
         *
         * See new code to know minimum stuff to add in your class for this purpose.
         * <pre>
         * public abstract class AbstractBean implements Serializable {
         *
         *     private static final long serialVersionUID = 1L;
         *
         *     protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
         *
         *     public void addPropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(listener);
         *     }
         *
         *     public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.addPropertyChangeListener(propertyName, listener);
         *     }
         *
         *     public void removePropertyChangeListener(PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(listener);
         *     }
         *
         *     public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
         *         pcs.removePropertyChangeListener(propertyName, listener);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
         *         pcs.firePropertyChange(propertyName, oldValue, newValue);
         *     }
         *
         *     protected void firePropertyChange(String propertyName, Object newValue) {
         *         firePropertyChange(propertyName, null, newValue);
         *     }
         *
         *     protected &lt;T&gt; T getChild(Collection&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         *
         *     protected &lt;T&gt; T getChild(List&lt;T&gt; list, int index) {
         *         return CollectionUtil.getOrNull(list, index);
         *     }
         * }
         * </pre>
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceSuperClass(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * Tag value to use a super super-class for generated defaults class of a simple bean.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceDefaultsSuperClassTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceDefaultsSuperClass(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceDefaultsSuperClass"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceClassNamePrefix(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceClassNamePrefix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceClassNameSuffix(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceClassNameSuffix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a prefix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceDefaultsClassNamePrefixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceDefaultsClassNamePrefix(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceDefaultsClassNamePrefix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class),

        /**
         * To add a suffix on the name of each generated bean class.
         *
         * You can globaly use it on the complete model or to a specific classifier.
         *
         * @see #getSimpleBeanWithNoInterfaceDefaultsClassNameSuffixTagValue(ObjectModelClassifier, ObjectModelPackage, ObjectModel)
         * @since 3.0
         */
        simpleBeanWithNoInterfaceDefaultsClassNameSuffix(n("eugene.simpleBeanWithNoInterfaceTransformer.tagvalue.simpleBeanWithNoInterfaceDefaultsClassNameSuffix"), String.class, null, ObjectModel.class, ObjectModelPackage.class, ObjectModelClassifier.class);

        private final Set<Class<?>> targets;
        private final Class<?> type;
        private final String i18nDescriptionKey;
        private final String defaultValue;

        Store(String i18nDescriptionKey, Class<?> type, String defaultValue, Class<?>... targets) {
            this.targets = ImmutableSet.copyOf(targets);
            this.type = type;
            this.i18nDescriptionKey = i18nDescriptionKey;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return name();
        }

        @Override
        public Set<Class<?>> getTargets() {
            return targets;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public Class<EqualsTagValueNameMatcher> getMatcherClass() {
            return EqualsTagValueNameMatcher.class;
        }

        @Override
        public String getDescription() {
            return t(i18nDescriptionKey);
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }

    }

    public SimpleJavaBeanWithNoInterfaceTransformerTagValues() {
        super((TagValueMetadata[]) Store.values());
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceSuperClass
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceSuperClass, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceDefaultsSuperClass} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceDefaultsSuperClass
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceDefaultsSuperClassTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceDefaultsSuperClass, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceClassNamePrefix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceClassNamePrefix
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceClassNamePrefix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceClassNameSuffix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceClassNameSuffix
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceClassNameSuffix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceDefaultsClassNamePrefix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceDefaultsClassNamePrefix
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceDefaultsClassNamePrefixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceDefaultsClassNamePrefix, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceDefaultsClassNameSuffix} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceDefaultsClassNameSuffix
     * @since 3.0
     */
    public String getSimpleBeanWithNoInterfaceDefaultsClassNameSuffixTagValue(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        String value = TagValueUtil.findTagValue(Store.simpleBeanWithNoInterfaceDefaultsClassNameSuffix, classifier, aPackage, model);
        if (StringUtils.isBlank(value)) {
            value = "s";
        }
        return value;
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceGenerateDefaults} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceGenerateDefaults
     * @since 3.0
     */
    public boolean isSimpleBeanWithNoInterfaceSkipGenerateDefaults(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanWithNoInterfaceGenerateDefaults, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceGeneratePredicates} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceGeneratePredicates
     * @since 3.0
     */
    public boolean isSimpleBeanWithNoInterfaceSkipGeneratePredicates(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanWithNoInterfaceGeneratePredicates, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceGenerateFunctions} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceGenerateFunctions
     * @since 3.0
     */
    public boolean isSimpleBeanWithNoInterfaceSkipGenerateFunctions(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanWithNoInterfaceGenerateFunctions, classifier, aPackage, model);
    }

    /**
     * Obtain the value of the {@link Store#simpleBeanWithNoInterfaceSkipGenerateConstructors} tag value on the given model or classifier.
     *
     * It will first look on the model, and then in the given classifier.
     *
     * <strong>If not filled, then use default {@code s} value.</strong>
     *
     * @param classifier classifier to seek
     * @param model      model to seek
     * @return the none empty value of the found tag value or {@code null} if not found nor empty.
     * @see Store#simpleBeanWithNoInterfaceSkipGenerateConstructors
     * @since 3.0
     */
    public boolean isSimpleBeanWithNoInterfaceSkipGenerateDefaultConstructors(ObjectModelClassifier classifier, ObjectModelPackage aPackage, ObjectModel model) {
        return TagValueUtil.findBooleanTagValue(Store.simpleBeanWithNoInterfaceSkipGenerateConstructors, classifier, aPackage, model);
    }

}
