/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.instantrunoff;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.EmptyVoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.instantrunoff.InstantRunoffDetailResult;
import org.chorem.pollen.votecounting.impl.instantrunoff.InstantRunoffRound;
import org.chorem.pollen.votecounting.impl.instantrunoff.InstantRunoffRoundChoice;

public class InstantRunoffVoteCountingStrategy
extends AbstractVoteCountingStrategy<EmptyVoteCountingConfig> {
    public InstantRunoffVoteCountingStrategy() {
        super(EmptyVoteCountingConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        InstantRunoffDetailResult detailResult = new InstantRunoffDetailResult();
        double totalWeight = voters.stream().mapToDouble(Voter::getWeight).sum() / 2.0;
        Map<Voter, List<Set<String>>> topRankChoices = this.buildVoterSortedChoices(voters);
        HashSet choiceIdsToKeep = Sets.newHashSet(scores.keySet());
        this.round(topRankChoices, choiceIdsToKeep, scores, totalWeight, detailResult, -scores.keySet().size());
        return this.orderByValues(scores.values(), detailResult);
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = choiceScore.getScoreOrder();
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }

    protected void round(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsEnabled, Map<String, ChoiceScore> resultByChoice, double totalWeight, InstantRunoffDetailResult detailResult, int roundIndex) {
        InstantRunoffRound round = new InstantRunoffRound();
        detailResult.getRounds().add(round);
        List<ChoiceScore> results = this.applyScores(topRankChoices, idsEnabled, resultByChoice, round);
        if (!results.isEmpty()) {
            double max;
            BigDecimal scoreValue = results.get(results.size() - 1).getScoreValue();
            double d = max = scoreValue == null ? 0.0 : scoreValue.doubleValue();
            if (max < totalWeight) {
                Set<String> idsToExclude = this.guessChoiceIdsToRemove(results, round);
                idsEnabled.removeAll(idsToExclude);
                topRankChoices.values().stream().flatMap(Collection::stream).forEach(choiceIds -> choiceIds.removeAll(idsToExclude));
                topRankChoices.values().forEach(list -> list.removeIf(Collection::isEmpty));
                if (CollectionUtils.isNotEmpty(idsEnabled)) {
                    idsToExclude.stream().map(resultByChoice::get).forEach(score -> score.setScoreValue(BigDecimal.valueOf(roundIndex)));
                    this.round(topRankChoices, idsEnabled, resultByChoice, totalWeight, detailResult, roundIndex + 1);
                }
            }
        }
    }

    protected List<ChoiceScore> applyScores(Map<Voter, List<Set<String>>> topRankChoices, Set<String> idsEnabled, Map<String, ChoiceScore> resultByChoice, InstantRunoffRound round) {
        for (String string : idsEnabled) {
            resultByChoice.get(string).setScoreValue(BigDecimal.ZERO);
            this.addRoundChoice(round, string, 0.0);
        }
        for (Map.Entry entry : topRankChoices.entrySet()) {
            List idsByLevel = (List)entry.getValue();
            if (idsByLevel.isEmpty()) continue;
            Set winnerIds = (Set)idsByLevel.get(0);
            Voter voter = (Voter)entry.getKey();
            double voterWeight = voter.getWeight();
            for (String id : winnerIds) {
                ChoiceScore choiceScore = resultByChoice.get(id);
                choiceScore.addScoreValue(voterWeight);
                this.addRoundChoice(round, id, voterWeight);
            }
        }
        List<ChoiceScore> results = idsEnabled.stream().map(resultByChoice::get).sorted(Comparator.comparing(ChoiceScore::getScoreValue, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
        return results;
    }

    protected Set<String> guessChoiceIdsToRemove(List<ChoiceScore> results, InstantRunoffRound round) {
        BigDecimal minScore = results.stream().map(ChoiceScore::getScoreValue).min(BigDecimal::compareTo).orElse(ZERO_D);
        Set<String> idsToExclude = results.stream().filter(score -> minScore.equals(score.getScoreValue())).map(ChoiceScore::getChoiceId).collect(Collectors.toSet());
        round.getChoiceIdsExclude().addAll(idsToExclude);
        return idsToExclude;
    }

    protected void addRoundChoice(InstantRunoffRound round, String choiceId, double score) {
        InstantRunoffRoundChoice roundChoice = this.getRoundChoice(round, choiceId);
        roundChoice.addScoreValue(score);
    }

    protected InstantRunoffRoundChoice getRoundChoice(InstantRunoffRound round, String choiceId) {
        InstantRunoffRoundChoice result;
        Optional<InstantRunoffRoundChoice> roundChoiceOptional = round.getRoundChoices().stream().filter(rc -> rc.getChoiceId().equals(choiceId)).findFirst();
        if (roundChoiceOptional.isPresent()) {
            result = roundChoiceOptional.get();
        } else {
            result = new InstantRunoffRoundChoice();
            result.setChoiceId(choiceId);
            round.getRoundChoices().add(result);
        }
        return result;
    }
}

