/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.cumulative;

import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeConfig;
import org.chorem.pollen.votecounting.impl.cumulative.CumulativeVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class CumulativeVoteCounting
extends AbstractVoteCounting {
    public CumulativeVoteCounting() {
        super(VoteCountings.Cumulative);
    }

    public CumulativeVoteCountingStrategy newStrategy() {
        return new CumulativeVoteCountingStrategy();
    }

    @Override
    public CumulativeConfig createConfig() {
        return new CumulativeConfig();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(0.0);
    }

    @Override
    public Multimap<String, String> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        Multimap<String, String> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        CumulativeConfig cumulativeConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, CumulativeConfig.class);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue != null) {
            if (voteValue < 0.0) {
                errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.cumulative.voteValue.error.positive", (Object[])new Object[]{voteValue}));
            } else if (voteValue > (double)cumulativeConfig.getPoints()) {
                errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.cumulative.voteValue.error.max", (Object[])new Object[]{voteValue, cumulativeConfig.getPoints()}));
            }
        }
        return errorMap;
    }

    @Override
    public Multimap<String, String> validateVote(Voter vote, VoteCountingConfig config, Locale locale) {
        CumulativeConfig cumulativeConfig;
        Multimap<String, String> errorMap = super.validateVote(vote, config, locale);
        double totalValues = vote.getVoteForChoices().stream().mapToDouble(VoteForChoice::getVoteValue).filter(Objects::nonNull).sum();
        if (totalValues != (double)(cumulativeConfig = InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, CumulativeConfig.class)).getPoints()) {
            errorMap.put((Object)"totalValues", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.cumulative.totalValue.error.equal", (Object[])new Object[]{totalValues, cumulativeConfig.getPoints()}));
        }
        return errorMap;
    }
}

