/*
 * #%L
 * Pollen :: VoteCounting strategy :: Borda
 * $Id: BordaStrategy.java 3663 2012-08-28 20:16:54Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-votecounting-strategy-borda/src/main/java/org/chorem/pollen/votecounting/strategy/BordaStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.strategy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n.l_;
import static org.nuiton.i18n.I18n.n_;

/**
 * Condorcet.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public class BordaStrategy extends AbstractVoteCountingStrategy {

    public static final int ID = 4;

    /** Logger. */
    private static final Log log = LogFactory.getLog(BordaStrategy.class);

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public String getI18nName() {
        return n_("pollen.voteCountingType.borda");
    }

    @Override
    public String getI18nHelp() {
        return n_("pollen.voteCountingType.borda.help");
    }

    @Override
    public String getTotalVoteValueNotValidMessage(Locale locale) {
        // no validation on total value, so no message
        return null;
    }

    @Override
    public String getVoteValueNotValidMessage(Locale locale) {
        return l_(locale, "pollen.error.vote.invalidBordaVoteValue");
    }

    @Override
    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0 && voteValue < 100;
    }

    @Override
    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null;
    }

    @Override
    public boolean isDisplayResultsByChoice() {
        return false;
    }

    @Override
    public boolean isVoteValueValid(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    @Override
    public boolean isTotalVoteValueValid(int totalValues) {
        // no validation on total value
        return true;
    }

    @Override
    public VoteCountingResult votecount(Set<Voter> voters) {

        // get empty result by choice
        Map<String, ChoiceScore> resultByChoice = votersToResult(voters);

        // nb of choices
        int nbChoices = resultByChoice.keySet().size();

        if (log.isDebugEnabled()) {
            log.debug("Nb choices: " + nbChoices);
        }

        // calcul pour chaque votant de sa liste des choix dans son ordre préféré

        Map<Voter, List<Set<String>>> voterSortedChoices =
                buildVoterSortedChoices(voters);

        // calcul des points pour chaque choix selon son ordre d'arrivé (
        // le 1er à nbChoices *weight point, le second (nbChoices-1) * weight,...)

        for (Map.Entry<Voter, List<Set<String>>> entry : voterSortedChoices.entrySet()) {
            Voter voter = entry.getKey();
            double weight = voter.getWeight();
            double choiceWeight = nbChoices * weight;
            for (Set<String> sortedChoiceId : entry.getValue()) {

                for (String choiceId : sortedChoiceId) {

                    resultByChoice.get(choiceId).addScoreValue(choiceWeight);
                }
                choiceWeight -= weight;
            }
        }

        // transform map of result to list of them (and sort them)
        VoteCountingResult result = resultToList(resultByChoice);
        return result;
    }


}
