/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.base.Function;
import java.io.Serializable;
import java.math.BigDecimal;
import org.chorem.pollen.votecounting.model.ChoiceIdAble;

public class ChoiceScore
implements ChoiceIdAble,
Comparable<ChoiceScore>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Function<ChoiceScore, Integer> SCORE_BY_ORDER = new Function<ChoiceScore, Integer>(){

        public Integer apply(ChoiceScore input) {
            return input.getScoreOrder();
        }
    };
    protected static final BigDecimal MIN_VALUE = BigDecimal.valueOf(Double.MIN_VALUE);
    public static final Function<ChoiceScore, BigDecimal> SCORE_BY_VALUE = new Function<ChoiceScore, BigDecimal>(){

        public BigDecimal apply(ChoiceScore input) {
            BigDecimal value = input.getScoreValue();
            return value == null ? MIN_VALUE : value;
        }
    };
    private String choiceId;
    private BigDecimal scoreValue;
    private int scoreOrder;

    public static ChoiceScore newScore(String choiceId, BigDecimal scoreValue) {
        ChoiceScore choiceScore = new ChoiceScore();
        choiceScore.setChoiceId(choiceId);
        choiceScore.setScoreValue(scoreValue);
        return choiceScore;
    }

    @Override
    public String getChoiceId() {
        return this.choiceId;
    }

    public BigDecimal getScoreValue() {
        return this.scoreValue;
    }

    public int getScoreOrder() {
        return this.scoreOrder;
    }

    public void setScoreOrder(int scoreOrder) {
        this.scoreOrder = scoreOrder;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void addScoreValue(double scoreToAdd) {
        BigDecimal newScoreValue = this.scoreValue == null ? BigDecimal.valueOf(scoreToAdd) : this.scoreValue.add(BigDecimal.valueOf(scoreToAdd));
        this.setScoreValue(newScoreValue);
    }

    public void setScoreValue(BigDecimal scoreValue) {
        this.scoreValue = scoreValue;
    }

    @Override
    public int compareTo(ChoiceScore o) {
        return this.scoreOrder - o.scoreOrder;
    }
}

