/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.security;

import org.apache.shiro.web.filter.authc.UserFilter;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.ui.PollenSession;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class AdminUserRequired extends UserFilter {

    @Override
    protected boolean isAccessAllowed(ServletRequest request,
                                      ServletResponse response,
                                      Object mappedValue) {

        PollenSession pollenSession = PollenSession.get(request);

        UserAccount userAccount = pollenSession.getUserAccount();

        boolean isAccessAllowed = userAccount != null &&
                                  userAccount.isAdministrator();

        return isAccessAllowed;
    }

}
