/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ConfirmDeleteVote.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/vote/ConfirmDeleteVote.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

/**
 * To confirm delete of a poll vote
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ConfirmDeleteVote extends PollenActionSupport implements PollenUserSecurityAware, PollUriAware {

    private static final long serialVersionUID = 1L;

    /**
     * Id of the vote to delete.
     *
     * @since 1.3
     */
    protected String voteId;

    /**
     * Loaded vote to delete.
     *
     * @since 1.3
     */
    protected Vote vote;

    public void setVoteId(String voteId) {
        this.voteId = voteId;
    }

    public Vote getVote() {
        return vote;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(voteId);

        Poll poll = getUserSecurityContext().getPoll();

        vote = poll.getVoteByTopiaId(voteId);

        return SUCCESS;
    }

}
