/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.ui.actions.poll.vote.AbstractVoteAction;

public class AddComment
extends AbstractVoteAction
implements Preparable {
    private static final long serialVersionUID = 1L;
    private String commentText;

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public boolean isModerate() {
        return false;
    }

    public void prepare() throws Exception {
        this.loadPoll();
        this.loadPollAccount();
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getCommentAuthor())) {
            this.addFieldError("commentAuthor", this._("pollen.error.comment.name.empty", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.getCommentText())) {
            this.addFieldError("commentText", this._("pollen.error.comment.text.empty", new Object[0]));
        }
    }

    @InputConfig(methodName="prepareVotePage")
    public String execute() throws Exception {
        Comment comment = this.getPollCommentService().getNewComment(this.getPollAccount(), this.getCommentAuthor(), this.getCommentText());
        this.getPollCommentService().createComment(this.getPoll(), comment);
        this.addFlashMessage(this._("pollen.information.comment.added", new Object[0]));
        return "success";
    }
}

