/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.UserAccount;

public class PollenSession
implements Serializable {
    private static final Log log = LogFactory.getLog(PollenSession.class);
    protected static final String SESSION_PARAMETER = "pollenSession";
    public static final String SESSION_TOKEN_MESSAGES = "messages";
    public static final String SESSION_TOKEN_ERRORS = "errors";
    public static final String SESSION_TOKEN_WARNINGS = "warnings";
    private static final long serialVersionUID = -1L;
    private UserAccount userAccount;
    private Map<String, Serializable> dynamicData;

    public static PollenSession get(ServletRequest servletRequest) {
        HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession(true);
        PollenSession pollenSession = (PollenSession)httpSession.getAttribute(SESSION_PARAMETER);
        if (pollenSession == null) {
            pollenSession = new PollenSession();
            httpSession.setAttribute(SESSION_PARAMETER, (Object)pollenSession);
        }
        return pollenSession;
    }

    public static PollenSession get(ActionContext actionContext) {
        Map strutsSession = actionContext.getSession();
        PollenSession session = (PollenSession)strutsSession.get(SESSION_PARAMETER);
        if (session == null) {
            session = new PollenSession();
            strutsSession.put(SESSION_PARAMETER, session);
        }
        return session;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
    }

    public <T extends Serializable> T getDynamicData(String token) {
        Serializable result = (Serializable)this.getDynamicData().get(token);
        return (T)result;
    }

    public <T extends Serializable> Set<T> getDynamicSetData(String token) {
        Serializable result = (Serializable)this.getDynamicData().get(token);
        return (Set)((Object)result);
    }

    public <T extends Serializable> T consumeDynamicData(String token) {
        Serializable result = this.getDynamicData(token);
        if (result != null) {
            this.removeDynamicData(token);
        }
        return (T)result;
    }

    public <T extends Serializable> Set<T> consumeDynamicSetData(String token) {
        Set result = this.getDynamicSetData(token);
        if (result != null) {
            this.removeDynamicData(token);
        }
        return result;
    }

    public <T extends Serializable> void putDynamicSetData(String token, Set<T> data) {
        this.getDynamicData().put(token, (Serializable)((Object)data));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void putDynamicData(String token, Serializable data) {
        this.getDynamicData().put(token, data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void removeDynamicData(String token) {
        this.getDynamicData().remove(token);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dynamic attributes size : " + this.getDynamicData().size()));
        }
    }

    public void clearDynamicData() {
        if (this.dynamicData != null) {
            this.dynamicData.clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dynamic attributes size : " + this.dynamicData.size()));
            }
        }
    }

    protected Map<String, Serializable> getDynamicData() {
        if (this.dynamicData == null) {
            this.dynamicData = Maps.newHashMap();
        }
        return this.dynamicData;
    }

    public void addMessage(String messageScope, String message) {
        Set messages = this.getDynamicSetData(messageScope);
        if (messages == null) {
            messages = Sets.newHashSet((Object[])new String[]{message});
            this.putDynamicSetData(messageScope, messages);
        } else {
            messages.add(message);
        }
    }

    public void removeDynamicDataWithPrefix(String prefix) {
        Iterator itr = this.getDynamicData().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            itr.remove();
        }
    }
}

