/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.it;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestWatcher;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class WebDriverResources
extends TestWatcher {
    private static final Log log = LogFactory.getLog(WebDriverResources.class);
    protected static Iterable<Object[]> driverTypes;
    protected static Map<Class<? extends WebDriver>, WebDriver> drivers;

    public static Iterable<Object[]> driverTypes() {
        if (driverTypes == null) {
            ArrayList allDrivers = Lists.newArrayList();
            allDrivers.add(FirefoxDriver.class);
            String extraDriverProperty = System.getProperty("extraDrivers");
            if (StringUtils.isNotBlank((CharSequence)extraDriverProperty)) {
                String[] extraDrivers;
                for (String extraDriverFqn : extraDrivers = extraDriverProperty.split("\\s*,\\s*")) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Try to add extra driver " + extraDriverFqn));
                    }
                    try {
                        Class<?> newDriver = Class.forName(extraDriverFqn);
                        allDrivers.add(newDriver);
                    }
                    catch (ClassNotFoundException e) {
                        if (!log.isErrorEnabled()) continue;
                        log.error((Object)("Could not load class " + extraDriverFqn), (Throwable)e);
                    }
                }
            }
            ArrayList checkedDrivers = Lists.newArrayList();
            for (Class driverType : allDrivers) {
                try {
                    Object driver = WebDriverResources.createDriver(driverType);
                    checkedDrivers.add(driverType);
                    drivers.put(driverType, (WebDriver)driver);
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Can not use driver " + driverType.getName()), (Throwable)e);
                }
            }
            Object[][] data = new Object[checkedDrivers.size()][1];
            int i = 0;
            for (Class checkedDriver : checkedDrivers) {
                data[i++][0] = checkedDriver;
            }
            driverTypes = Arrays.asList(data);
        }
        Preconditions.checkNotNull(driverTypes);
        return driverTypes;
    }

    public <W extends WebDriver> W getDriver(Class<W> driverType) throws Exception {
        Preconditions.checkNotNull(driverType);
        WebDriver result = drivers.get(driverType);
        Preconditions.checkNotNull((Object)result);
        return (W)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanDrivers() {
        try {
            for (WebDriver webDriver : drivers.values()) {
                try {
                    webDriver.quit();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Could not close nicely driver " + webDriver), (Throwable)e);
                }
            }
        }
        finally {
            drivers.clear();
        }
    }

    private static <W extends WebDriver> W createDriver(Class<W> driverType) throws Exception {
        WebDriver result = (WebDriver)driverType.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (HtmlUnitDriver.class == driverType) {
            ((HtmlUnitDriver)result).setJavascriptEnabled(true);
        }
        return (W)result;
    }

    static {
        drivers = Maps.newHashMap();
    }
}

